/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins;

import grails.core.GrailsApplication;
import grails.core.support.ParentApplicationContextAware;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.grails.core.exceptions.GrailsConfigurationException;
import org.grails.io.support.SpringIOUtils;
import org.grails.plugins.BinaryGrailsPluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CorePluginFinder
implements ParentApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(CorePluginFinder.class);
    public static final String CORE_PLUGIN_PATTERN = "META-INF/grails-plugin.xml";
    private final Set<Class<?>> foundPluginClasses = new HashSet();
    private final GrailsApplication application;
    private final Map<Class, BinaryGrailsPluginDescriptor> binaryDescriptors = new HashMap<Class, BinaryGrailsPluginDescriptor>();

    public CorePluginFinder(GrailsApplication application) {
        this.application = application;
    }

    public Class<?>[] getPluginClasses() {
        this.foundPluginClasses.clear();
        try {
            Resource[] resources = this.resolvePluginResources();
            if (resources.length <= 0) {
                throw new IllegalStateException("Grails was unable to load plugins dynamically. This is normally a problem with the container class loader configuration, see troubleshooting and FAQ for more info. ");
            }
            this.loadCorePluginsFromResources(resources);
        }
        catch (IOException e) {
            throw new IllegalStateException("WARNING: I/O exception loading core plugin dynamically, attempting static load. This is usually due to deployment onto containers with unusual classloading setups. Message: " + e.getMessage());
        }
        return this.foundPluginClasses.toArray(new Class[this.foundPluginClasses.size()]);
    }

    public BinaryGrailsPluginDescriptor getBinaryDescriptor(Class<?> pluginClass) {
        return this.binaryDescriptors.get(pluginClass);
    }

    private Resource[] resolvePluginResources() throws IOException {
        Enumeration<URL> resources = this.application.getClassLoader().getResources(CORE_PLUGIN_PATTERN);
        ArrayList<UrlResource> resourceList = new ArrayList<UrlResource>();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            resourceList.add(new UrlResource(url));
        }
        return resourceList.toArray(new Resource[resourceList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCorePluginsFromResources(Resource[] resources) throws IOException {
        LOG.debug("Attempting to load [" + resources.length + "] core plugins");
        try {
            SAXParser saxParser = SpringIOUtils.newSAXParser();
            for (Resource resource : resources) {
                try (InputStream input = null;){
                    input = resource.getInputStream();
                    PluginHandler ph = new PluginHandler();
                    saxParser.parse(input, (DefaultHandler)ph);
                    for (String pluginType : ph.pluginTypes) {
                        Class<?> pluginClass = this.attemptCorePluginClassLoad(pluginType);
                        if (pluginClass == null) continue;
                        this.addPlugin(pluginClass);
                        this.binaryDescriptors.put(pluginClass, new BinaryGrailsPluginDescriptor(resource, ph.pluginClasses));
                    }
                }
            }
        }
        catch (ParserConfigurationException e) {
            throw new GrailsConfigurationException("XML parsing error loading core plugins: " + e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new GrailsConfigurationException("XML parsing error loading core plugins: " + e.getMessage(), e);
        }
    }

    private Class<?> attemptCorePluginClassLoad(String pluginClassName) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return classLoader.loadClass(pluginClassName);
        }
        catch (ClassNotFoundException e) {
            LOG.warn("[GrailsPluginManager] Core plugin [" + pluginClassName + "] not found, resuming load without..");
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    private void addPlugin(Class<?> plugin) {
        this.foundPluginClasses.add(plugin);
    }

    @Override
    public void setParentApplicationContext(ApplicationContext parent) {
    }

    class PluginHandler
    extends DefaultHandler {
        PluginParseState state = PluginParseState.PARSING;
        List<String> pluginTypes = new ArrayList<String>();
        List<String> pluginClasses = new ArrayList<String>();
        private StringBuilder buff = new StringBuilder();

        PluginHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.equals("type")) {
                this.state = PluginParseState.TYPE;
                this.buff = new StringBuilder();
            } else if (localName.equals("resource")) {
                this.state = PluginParseState.RESOURCE;
                this.buff = new StringBuilder();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            switch (this.state) {
                case TYPE: {
                    this.buff.append(String.valueOf(ch, start, length));
                    break;
                }
                case RESOURCE: {
                    this.buff.append(String.valueOf(ch, start, length));
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            switch (this.state) {
                case TYPE: {
                    this.pluginTypes.add(this.buff.toString());
                    break;
                }
                case RESOURCE: {
                    this.pluginClasses.add(this.buff.toString());
                }
            }
            this.state = PluginParseState.PARSING;
        }
    }

    private static enum PluginParseState {
        PARSING,
        TYPE,
        RESOURCE;

    }
}

