/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.beans;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanConstructor;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanMethod;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.UnsafeBeanProperty;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.inject.ExecutableMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractInitializableBeanIntrospection<B>
implements BeanIntrospection<B> {
    private final Class<B> beanType;
    private final AnnotationMetadata annotationMetadata;
    private final AnnotationMetadata constructorAnnotationMetadata;
    private final Argument<?>[] constructorArguments;
    private final List<BeanProperty<B, Object>> beanProperties;
    private final List<BeanMethod<B, Object>> beanMethods;
    private BeanConstructor<B> beanConstructor;

    public AbstractInitializableBeanIntrospection(Class<B> beanType, AnnotationMetadata annotationMetadata, AnnotationMetadata constructorAnnotationMetadata, Argument<?>[] constructorArguments, BeanPropertyRef<Object>[] propertiesRefs, BeanMethodRef<Object>[] methodsRefs) {
        this.beanType = beanType;
        this.annotationMetadata = annotationMetadata == null ? AnnotationMetadata.EMPTY_METADATA : annotationMetadata;
        this.constructorAnnotationMetadata = constructorAnnotationMetadata == null ? AnnotationMetadata.EMPTY_METADATA : constructorAnnotationMetadata;
        Object[] objectArray = this.constructorArguments = constructorArguments == null ? Argument.ZERO_ARGUMENTS : constructorArguments;
        if (propertiesRefs != null) {
            ArrayList beanProperties = new ArrayList(propertiesRefs.length);
            for (BeanPropertyRef<Object> beanPropertyRef : propertiesRefs) {
                beanProperties.add(new BeanPropertyImpl(beanPropertyRef));
            }
            this.beanProperties = Collections.unmodifiableList(beanProperties);
        } else {
            this.beanProperties = Collections.emptyList();
        }
        if (methodsRefs != null) {
            ArrayList beanMethods = new ArrayList(methodsRefs.length);
            for (BeanMethodRef<Object> beanMethodRef : methodsRefs) {
                beanMethods.add(new BeanMethodImpl(beanMethodRef));
            }
            this.beanMethods = Collections.unmodifiableList(beanMethods);
        } else {
            this.beanMethods = Collections.emptyList();
        }
    }

    @NonNull
    @Internal
    protected abstract B instantiateInternal(@Nullable Object[] var1);

    @Internal
    protected BeanProperty<B, Object> getPropertyByIndex(int index) {
        return this.beanProperties.get(index);
    }

    @Internal
    protected abstract Method getTargetMethodByIndex(int var1);

    protected final Method getAccessibleTargetMethodByIndex(int index) {
        Method method = this.getTargetMethodByIndex(index);
        if (ClassUtils.REFLECTION_LOGGER.isDebugEnabled()) {
            ClassUtils.REFLECTION_LOGGER.debug("Reflectively accessing method {} of type {}", (Object)method, method.getDeclaringClass());
        }
        method.setAccessible(true);
        return method;
    }

    @Nullable
    protected <V> V dispatch(int index, @NonNull B target, @Nullable Object[] args) {
        throw this.unknownDispatchAtIndexException(index);
    }

    @Nullable
    protected <V> V dispatchOne(int index, @NonNull Object target, @Nullable Object arg) {
        throw this.unknownDispatchAtIndexException(index);
    }

    protected final RuntimeException unknownDispatchAtIndexException(int index) {
        return new IllegalStateException("Unknown dispatch at index: " + index);
    }

    @Nullable
    public BeanProperty<B, Object> findIndexedProperty(@NonNull Class<? extends Annotation> annotationType, @NonNull String annotationValue) {
        return null;
    }

    @NonNull
    public Collection<BeanProperty<B, Object>> getIndexedProperties(@NonNull Class<? extends Annotation> annotationType) {
        return Collections.emptyList();
    }

    protected Collection<BeanProperty<B, Object>> getBeanPropertiesIndexedSubset(int[] indexes) {
        if (indexes.length == 0) {
            return Collections.emptyList();
        }
        return new IndexedCollections<BeanProperty<B, Object>>(indexes, this.beanProperties);
    }

    public B instantiate() throws InstantiationException {
        throw new InstantiationException("No default constructor exists");
    }

    @NonNull
    public B instantiate(boolean strictNullable, Object ... arguments) throws InstantiationException {
        ArgumentUtils.requireNonNull((String)"arguments", (Object)arguments);
        if (arguments.length == 0) {
            return this.instantiate();
        }
        Argument<?>[] constructorArguments = this.getConstructorArguments();
        if (constructorArguments.length != arguments.length) {
            throw new InstantiationException("Argument count [" + arguments.length + "] doesn't match required argument count: " + constructorArguments.length);
        }
        for (int i = 0; i < constructorArguments.length; ++i) {
            Argument<?> constructorArgument = constructorArguments[i];
            Object specified = arguments[i];
            if (specified == null) {
                if (constructorArgument.isDeclaredNullable() || !strictNullable) continue;
                throw new InstantiationException("Null argument specified for [" + constructorArgument.getName() + "]. If this argument is allowed to be null annotate it with @Nullable");
            }
            if (ReflectionUtils.getWrapperType((Class)constructorArgument.getType()).isInstance(specified)) continue;
            throw new InstantiationException("Invalid argument [" + specified + "] specified for argument: " + constructorArgument);
        }
        return this.instantiateInternal(arguments);
    }

    public BeanConstructor<B> getConstructor() {
        if (this.beanConstructor == null) {
            this.beanConstructor = new BeanConstructor<B>(){

                public Class<B> getDeclaringBeanType() {
                    return AbstractInitializableBeanIntrospection.this.beanType;
                }

                public Argument<?>[] getArguments() {
                    return AbstractInitializableBeanIntrospection.this.constructorArguments;
                }

                public B instantiate(Object ... parameterValues) {
                    return AbstractInitializableBeanIntrospection.this.instantiate(parameterValues);
                }

                public AnnotationMetadata getAnnotationMetadata() {
                    return AbstractInitializableBeanIntrospection.this.constructorAnnotationMetadata;
                }
            };
        }
        return this.beanConstructor;
    }

    public Argument<?>[] getConstructorArguments() {
        return this.constructorArguments;
    }

    @NonNull
    public Optional<BeanProperty<B, Object>> getIndexedProperty(@NonNull Class<? extends Annotation> annotationType, @NonNull String annotationValue) {
        return Optional.ofNullable(this.findIndexedProperty(annotationType, annotationValue));
    }

    @NonNull
    public Optional<BeanProperty<B, Object>> getProperty(@NonNull String name) {
        ArgumentUtils.requireNonNull((String)"name", (Object)name);
        int index = this.propertyIndexOf(name);
        return index == -1 ? Optional.empty() : Optional.of(this.beanProperties.get(index));
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @NonNull
    public Collection<BeanProperty<B, Object>> getBeanProperties() {
        return this.beanProperties;
    }

    @NonNull
    public Class<B> getBeanType() {
        return this.beanType;
    }

    @NonNull
    public Collection<BeanMethod<B, Object>> getBeanMethods() {
        return this.beanMethods;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractInitializableBeanIntrospection that = (AbstractInitializableBeanIntrospection)o;
        return Objects.equals(this.beanType, that.beanType);
    }

    public int hashCode() {
        return Objects.hash(this.beanType);
    }

    public String toString() {
        return "BeanIntrospection{type=" + this.beanType + '}';
    }

    @Internal
    public static final class BeanMethodRef<P> {
        @NonNull
        final Argument<P> returnType;
        @NonNull
        final String name;
        @Nullable
        final AnnotationMetadata annotationMetadata;
        @Nullable
        final Argument<?>[] arguments;
        final int methodIndex;

        public BeanMethodRef(@NonNull Argument<P> returnType, @NonNull String name, @Nullable AnnotationMetadata annotationMetadata, @Nullable Argument<?>[] arguments, int methodIndex) {
            this.returnType = returnType;
            this.name = name;
            this.annotationMetadata = annotationMetadata;
            this.arguments = arguments;
            this.methodIndex = methodIndex;
        }
    }

    @Internal
    public static final class BeanPropertyRef<P> {
        @NonNull
        final Argument<P> argument;
        final int getMethodIndex;
        final int setMethodIndex;
        final int withMethodIndex;
        final boolean readyOnly;
        final boolean mutable;

        public BeanPropertyRef(@NonNull Argument<P> argument, int getMethodIndex, int setMethodIndex, int valueMethodIndex, boolean readyOnly, boolean mutable) {
            this.argument = argument;
            this.getMethodIndex = getMethodIndex;
            this.setMethodIndex = setMethodIndex;
            this.withMethodIndex = valueMethodIndex;
            this.readyOnly = readyOnly;
            this.mutable = mutable;
        }
    }

    private final class BeanMethodImpl<P>
    implements BeanMethod<B, P>,
    ExecutableMethod<B, P> {
        private final BeanMethodRef<P> ref;

        private BeanMethodImpl(BeanMethodRef<P> ref) {
            this.ref = ref;
        }

        @NonNull
        public BeanIntrospection<B> getDeclaringBean() {
            return AbstractInitializableBeanIntrospection.this;
        }

        @Override
        @NonNull
        public ReturnType<P> getReturnType() {
            return new ReturnType(){

                public Class<P> getType() {
                    return ((BeanMethodImpl)BeanMethodImpl.this).ref.returnType.getType();
                }

                @NonNull
                public Argument<P> asArgument() {
                    return ((BeanMethodImpl)BeanMethodImpl.this).ref.returnType;
                }

                public Map<String, Argument<?>> getTypeVariables() {
                    return ((BeanMethodImpl)BeanMethodImpl.this).ref.returnType.getTypeVariables();
                }

                @NonNull
                public AnnotationMetadata getAnnotationMetadata() {
                    return ((BeanMethodImpl)BeanMethodImpl.this).ref.returnType.getAnnotationMetadata();
                }
            };
        }

        @NonNull
        public AnnotationMetadata getAnnotationMetadata() {
            return this.ref.annotationMetadata == null ? AnnotationMetadata.EMPTY_METADATA : this.ref.annotationMetadata;
        }

        @Override
        @NonNull
        public String getName() {
            return this.ref.name;
        }

        @Override
        public Argument<?>[] getArguments() {
            return this.ref.arguments == null ? Argument.ZERO_ARGUMENTS : this.ref.arguments;
        }

        public P invoke(@NonNull B instance, Object ... arguments) {
            return (P)AbstractInitializableBeanIntrospection.this.dispatch(this.ref.methodIndex, instance, arguments);
        }

        @Override
        public Method getTargetMethod() {
            if (ClassUtils.REFLECTION_LOGGER.isWarnEnabled()) {
                ClassUtils.REFLECTION_LOGGER.warn("Using getTargetMethod for method {} on type {} requires the use of reflection. GraalVM configuration necessary", (Object)this.getName(), this.getDeclaringType());
            }
            return AbstractInitializableBeanIntrospection.this.getTargetMethodByIndex(this.ref.methodIndex);
        }

        @Override
        public Class<B> getDeclaringType() {
            return this.getDeclaringBean().getBeanType();
        }

        @Override
        public String getMethodName() {
            return this.getName();
        }
    }

    private final class BeanPropertyImpl<P>
    implements UnsafeBeanProperty<B, P> {
        private final BeanPropertyRef<P> ref;
        private final Class<?> typeOrWrapperType;

        private BeanPropertyImpl(BeanPropertyRef<P> ref) {
            this.ref = ref;
            this.typeOrWrapperType = ReflectionUtils.getWrapperType(this.getType());
        }

        @NonNull
        public String getName() {
            return this.ref.argument.getName();
        }

        @NonNull
        public Class<P> getType() {
            return this.ref.argument.getType();
        }

        @NonNull
        public Argument<P> asArgument() {
            return this.ref.argument;
        }

        @NonNull
        public BeanIntrospection<B> getDeclaringBean() {
            return AbstractInitializableBeanIntrospection.this;
        }

        public AnnotationMetadata getAnnotationMetadata() {
            return this.ref.argument.getAnnotationMetadata();
        }

        @Nullable
        public P get(@NonNull B bean) {
            ArgumentUtils.requireNonNull((String)"bean", bean);
            if (!AbstractInitializableBeanIntrospection.this.beanType.isInstance(bean)) {
                throw new IllegalArgumentException("Invalid bean [" + bean + "] for type: " + AbstractInitializableBeanIntrospection.this.beanType);
            }
            if (this.isWriteOnly()) {
                throw new UnsupportedOperationException("Cannot read from a write-only property: " + this.getName());
            }
            return (P)AbstractInitializableBeanIntrospection.this.dispatchOne(this.ref.getMethodIndex, bean, null);
        }

        public P getUnsafe(B bean) {
            return (P)AbstractInitializableBeanIntrospection.this.dispatchOne(this.ref.getMethodIndex, bean, null);
        }

        public void set(@NonNull B bean, @Nullable P value) {
            ArgumentUtils.requireNonNull((String)"bean", bean);
            if (!AbstractInitializableBeanIntrospection.this.beanType.isInstance(bean)) {
                throw new IllegalArgumentException("Invalid bean [" + bean + "] for type: " + bean);
            }
            if (this.isReadOnly()) {
                throw new UnsupportedOperationException("Cannot write a read-only property: " + this.getName());
            }
            if (value != null && !this.typeOrWrapperType.isInstance(value)) {
                throw new IllegalArgumentException("Specified value [" + value + "] is not of the correct type: " + this.getType());
            }
            AbstractInitializableBeanIntrospection.this.dispatchOne(this.ref.setMethodIndex, bean, value);
        }

        public void setUnsafe(B bean, P value) {
            AbstractInitializableBeanIntrospection.this.dispatchOne(this.ref.setMethodIndex, bean, value);
        }

        public B withValue(@NonNull B bean, @Nullable P value) {
            ArgumentUtils.requireNonNull((String)"bean", bean);
            if (!AbstractInitializableBeanIntrospection.this.beanType.isInstance(bean)) {
                throw new IllegalArgumentException("Invalid bean [" + bean + "] for type: " + AbstractInitializableBeanIntrospection.this.beanType);
            }
            return this.withValueUnsafe(bean, value);
        }

        public B withValueUnsafe(B bean, P value) {
            if (value == this.getUnsafe(bean)) {
                return bean;
            }
            if (this.ref.withMethodIndex == -1) {
                if (!this.ref.readyOnly && this.ref.setMethodIndex != -1) {
                    AbstractInitializableBeanIntrospection.this.dispatchOne(this.ref.setMethodIndex, bean, value);
                    return bean;
                }
                return super.withValue(bean, value);
            }
            return AbstractInitializableBeanIntrospection.this.dispatchOne(this.ref.withMethodIndex, bean, value);
        }

        public boolean isReadOnly() {
            return this.ref.readyOnly;
        }

        public boolean isWriteOnly() {
            return this.ref.getMethodIndex == -1 && (this.ref.setMethodIndex != -1 || this.ref.withMethodIndex != -1);
        }

        public boolean hasSetterOrConstructorArgument() {
            return this.ref.mutable;
        }

        public String toString() {
            return "BeanProperty{beanType=" + AbstractInitializableBeanIntrospection.this.beanType + ", type=" + this.ref.argument.getType() + ", name='" + this.ref.argument.getName() + '\'' + '}';
        }
    }

    private static final class IndexedCollections<T>
    extends AbstractCollection<T> {
        private final int[] indexed;
        private final List<T> list;

        private IndexedCollections(int[] indexed, List<T> list) {
            this.indexed = indexed;
            this.list = list;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                int i = -1;

                @Override
                public boolean hasNext() {
                    return this.i + 1 < indexed.length;
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    int index = indexed[++this.i];
                    return list.get(index);
                }
            };
        }

        @Override
        public int size() {
            return this.indexed.length;
        }
    }
}

