/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.cli.internal;

import java.io.PrintWriter;
import java.util.concurrent.Callable;
import org.kordamp.jarviz.cli.IO;
import org.kordamp.jarviz.cli.internal.Banner;
import org.kordamp.jarviz.cli.internal.BaseCommand;
import org.kordamp.jarviz.cli.internal.ErrorColorizer;
import org.kordamp.jarviz.cli.internal.Versions;
import org.kordamp.jarviz.core.InsufficientInputsException;
import org.kordamp.jarviz.core.JarvizException;
import picocli.CommandLine;

@CommandLine.Command(mixinStandardHelpOptions=true, versionProvider=Versions.class)
public abstract class AbstractCommand<C extends IO>
extends BaseCommand
implements Callable<Integer>,
IO {
    protected abstract C parent();

    @Override
    public PrintWriter getOut() {
        return this.parent().getOut();
    }

    @Override
    public void setOut(PrintWriter out) {
        this.parent().setOut(out);
    }

    @Override
    public PrintWriter getErr() {
        return this.parent().getErr();
    }

    @Override
    public void setErr(PrintWriter err) {
        this.parent().setErr(err);
    }

    @Override
    public Integer call() {
        this.setup();
        try {
            return this.execute();
        }
        catch (InsufficientInputsException e) {
            ErrorColorizer colorizer = new ErrorColorizer(this.parent().getOut());
            String message = e.getMessage();
            colorizer.println(message);
            this.printDetails(e.getCause(), message, colorizer);
            this.spec.commandLine().usage(this.getOut());
            return 1;
        }
        catch (JarvizException e) {
            ErrorColorizer colorizer = new ErrorColorizer(this.parent().getOut());
            String message = e.getMessage();
            colorizer.println(message);
            this.printDetails(e.getCause(), message, colorizer);
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace(new ErrorColorizer(this.parent().getOut()));
            return 1;
        }
    }

    protected void printDetails(Throwable throwable, String message, ErrorColorizer colorizer) {
        if (null == throwable) {
            return;
        }
        String myMessage = throwable.getMessage();
        if (!message.equals(myMessage)) {
            colorizer.println(myMessage);
        } else {
            this.printDetails(throwable.getCause(), message, colorizer);
        }
    }

    protected void setup() {
        Banner.display(this.parent().getErr());
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "error");
    }

    protected abstract int execute();
}

