/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.loadbalancer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.loadbalancer.ByteBufferPool;
import org.mortbay.loadbalancer.Listener;
import org.mortbay.loadbalancer.NonBlockingQueue;
import org.mortbay.loadbalancer.Server;

public class Connection {
    static Log log = LogFactory.getLog((Class)(class$org$mortbay$loadbalancer$Connection == null ? (class$org$mortbay$loadbalancer$Connection = Connection.class$("org.mortbay.loadbalancer.Connection")) : class$org$mortbay$loadbalancer$Connection));
    ByteBufferPool _bufferPool;
    private Listener _listener;
    private Server _server;
    private QueuedChannel _serverQ;
    private QueuedChannel _clientQ;
    private int _allocationTry;
    static /* synthetic */ Class class$org$mortbay$loadbalancer$Connection;

    public Connection(ByteBufferPool bufferPool, Listener listener, SocketChannel client, int capacity) {
        this._bufferPool = bufferPool;
        this._listener = listener;
        this._clientQ = new QueuedChannel(capacity, client, listener.getSelector());
        this._serverQ = new QueuedChannel(capacity, null, null);
        this._clientQ.setReverse(this._serverQ);
        this._serverQ.setReverse(this._clientQ);
    }

    public SocketChannel getClientSocketChannel() {
        return this._clientQ._channel;
    }

    public synchronized void client2server(SelectionKey key) throws IOException {
        this._serverQ.read(key);
        if (!this.isAllocated()) {
            this._listener.getPolicy().allocate(this, this._serverQ, 0);
        }
    }

    public synchronized void serverWriteWakeup(SelectionKey key) throws IOException {
        this._serverQ.writeWakeup(key);
    }

    public synchronized void server2client(SelectionKey key) throws IOException {
        this._clientQ.read(key);
    }

    public synchronized void clientWriteWakeup(SelectionKey key) throws IOException {
        this._clientQ.writeWakeup(key);
    }

    public synchronized void allocate(Server server, int allocationTry) throws IOException {
        this._server = server;
        this._allocationTry = allocationTry;
        server.connect(this);
    }

    public synchronized void deallocate() throws IOException {
        this._server = null;
        this._serverQ._channel = null;
        this._serverQ._selector = null;
        this._listener.getPolicy().deallocate(this, this._serverQ, this._allocationTry);
    }

    public synchronized void connected(SocketChannel channel, Selector selector) throws IOException {
        this._serverQ._channel = channel;
        this._serverQ._selector = selector;
        if (!this._serverQ.isEmpty()) {
            this._serverQ.writeWakeup(null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Connect " + this));
        }
    }

    public boolean isAllocated() {
        return this._server != null;
    }

    public synchronized void close() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing " + this));
        }
        try {
            if (this._clientQ._channel != null && this._clientQ._channel.isOpen()) {
                this._clientQ._channel.socket().setTcpNoDelay(true);
                this._clientQ._channel.socket().shutdownOutput();
                this._clientQ._channel.socket().close();
                this._clientQ._channel.close();
            }
        }
        catch (IOException e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
        try {
            if (this._serverQ._channel != null && this._serverQ._channel.isOpen()) {
                this._serverQ._channel.close();
            }
        }
        catch (IOException e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
    }

    public String toString() {
        return (this._clientQ._channel != null ? this._clientQ._channel.socket().getRemoteSocketAddress() + "-->" + this._clientQ._channel.socket().getLocalPort() : "?-->?") + "-->" + (this._serverQ._channel != null ? this._serverQ._channel.socket().getRemoteSocketAddress().toString() : "?");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class QueuedChannel
    extends NonBlockingQueue {
        SocketChannel _channel;
        Selector _selector;
        QueuedChannel _reverse;

        QueuedChannel(int capacity, SocketChannel channel, Selector selector) {
            super(capacity);
            this._channel = channel;
            this._selector = selector;
        }

        void setReverse(QueuedChannel reverse) {
            this._reverse = reverse;
        }

        synchronized void read(SelectionKey key) throws IOException {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Read " + key));
            }
            if (this.isFull()) {
                key.interestOps(0xFFFFFFFE & key.interestOps());
            } else {
                SocketChannel socket_channel = (SocketChannel)key.channel();
                ByteBuffer buffer = Connection.this._bufferPool.get();
                int l = -1;
                while (!this.isFull() && (l = socket_channel.read(buffer)) > 0) {
                    buffer.flip();
                    this.write(buffer);
                    buffer = Connection.this._bufferPool.get();
                }
                Connection.this._bufferPool.add(buffer);
                if (l < 0) {
                    this.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void write(ByteBuffer buffer) throws IOException {
            if (buffer.remaining() == 0) {
                Connection.this._bufferPool.add(buffer);
                return;
            }
            if (this.isFull()) {
                throw new IllegalStateException("Full");
            }
            if (!this.isEmpty() || this._channel == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("QUEUE! " + buffer));
                }
                this.queue(buffer);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Write! " + buffer));
                }
                if (this._channel.write(buffer) < 0) {
                    Connection.this._bufferPool.add(buffer);
                    this.close();
                }
                if (buffer.remaining() > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("QUEUE " + buffer));
                    }
                    this.queue(buffer);
                    Selector selector = this._selector;
                    synchronized (selector) {
                        SelectionKey key = this._channel.keyFor(this._selector);
                        if (key != null) {
                            key.interestOps(4 | key.interestOps());
                        } else {
                            key = this._channel.register(this._selector, 4, Connection.this);
                        }
                        this._selector.wakeup();
                    }
                } else {
                    Connection.this._bufferPool.add(buffer);
                }
            }
        }

        synchronized void writeWakeup(SelectionKey key) throws IOException {
            if (log.isDebugEnabled()) {
                log.debug((Object)("WRITE WAKEUP: " + key));
            }
            boolean was_full = this.isFull();
            if (log.isDebugEnabled()) {
                log.debug((Object)("was_full==" + was_full + " isEmpty()==" + this.isEmpty()));
            }
            while (!this.isEmpty()) {
                int len;
                ByteBuffer buffer = (ByteBuffer)this.peek();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Write  " + buffer));
                }
                if ((len = this._channel.write(buffer)) < 0) {
                    Connection.this._bufferPool.add(buffer);
                    this.close();
                    return;
                }
                if (buffer.remaining() != 0) break;
                this.next();
                Connection.this._bufferPool.add(buffer);
            }
            if (key != null && this.isEmpty()) {
                key.interestOps(0xFFFFFFFB & key.interestOps());
            }
            if (was_full) {
                this._reverse.readRegister();
            }
        }

        void readRegister() throws IOException {
            SelectionKey key;
            if (log.isDebugEnabled()) {
                log.debug((Object)("READ REGISTER: " + this));
            }
            if ((key = this._channel.keyFor(this._selector)) != null) {
                key.interestOps(1 | key.interestOps());
            } else {
                this._channel.register(this._selector, 1, Connection.this);
            }
            this._selector.wakeup();
        }

        void close() {
            Connection.this.close();
        }
    }
}

