/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log;

import junit.textui.TestRunner;
import org.objectweb.howl.log.LogException;
import org.objectweb.howl.log.LogTestWorker;
import org.objectweb.howl.log.Logger;
import org.objectweb.howl.log.TestDriver;

public class ThroughputTest
extends TestDriver {
    public ThroughputTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)ThroughputTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.log = new Logger(this.cfg);
        this.prop.setProperty("msg.count", "200");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testLoggerThroughput_checksumEnabled() throws Exception {
        this.cfg.setChecksumEnabled(true);
        this.log.open();
        this.log.setAutoMark(true);
        this.runWorkers(LogTestWorker.class);
    }

    public void testLoggerThroughput_rw() throws Exception, LogException {
        this.log.open();
        this.log.setAutoMark(true);
        this.prop.setProperty("msg.force.interval", "0");
        this.prop.setProperty("msg.count", "1000");
        this.runWorkers(LogTestWorker.class);
    }

    public void testLoggerThroughput_rwd() throws Exception, LogException {
        this.cfg.setLogFileMode("rwd");
        this.log.open();
        this.log.setAutoMark(true);
        this.prop.setProperty("msg.force.interval", "0");
        this.prop.setProperty("msg.count", "1000");
        this.runWorkers(LogTestWorker.class);
    }

    public void testThroughput_1() throws Exception, LogException {
        this.log.open();
        this.log.setAutoMark(true);
        this.prop.setProperty("msg.count", "25");
        this.workers = 1;
        this.runWorkers(LogTestWorker.class);
    }

    public void testThroughput_25() throws Exception, LogException {
        this.cfg.setLogFileName("log_2k");
        this.cfg.setBufferSize(2);
        this.log.open();
        this.log.setAutoMark(true);
        this.workers = 25;
        this.runWorkers(LogTestWorker.class);
    }

    public void testThroughput_50() throws Exception, LogException {
        this.log.open();
        this.log.setAutoMark(true);
        this.workers = 50;
        this.runWorkers(LogTestWorker.class);
    }

    public void testThroughput_100() throws Exception, LogException {
        this.log.open();
        this.log.setAutoMark(true);
        this.workers = 100;
        this.runWorkers(LogTestWorker.class);
    }

    public void testThroughput_200() throws Exception, LogException {
        this.log.open();
        this.log.setAutoMark(true);
        this.workers = 200;
        this.runWorkers(LogTestWorker.class);
    }

    public void testThroughput_1200() throws Exception, LogException {
        this.cfg.setLogFileName("log_12k");
        this.cfg.setBufferSize(12);
        this.log.open();
        this.log.setAutoMark(true);
        this.workers = 1200;
        this.runWorkers(LogTestWorker.class);
    }

    public void testThroughput_2000() throws Exception, LogException {
        this.cfg.setLogFileName("log_12k");
        this.cfg.setBufferSize(12);
        this.log.open();
        this.log.setAutoMark(true);
        this.workers = 2000;
        this.runWorkers(LogTestWorker.class);
    }
}

