/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.Domain;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.MustacheUtils;

public class Checksum
implements Domain {
    public static final String KEY_SKIP_CHECKSUM = "skipChecksum";
    public static final String INDIVIDUAL_CHECKSUM = "individualChecksum";
    private final Set<Algorithm> algorithms = new LinkedHashSet<Algorithm>();
    private Boolean individual;
    private String name;
    private Boolean files;

    void setAll(Checksum checksum) {
        this.name = checksum.name;
        this.individual = checksum.individual;
        this.files = checksum.files;
        this.setAlgorithms(checksum.algorithms);
    }

    public String getResolvedName(JReleaserContext context) {
        Map<String, Object> props = context.props();
        context.getModel().getRelease().getGitService().fillProps(props, context.getModel());
        return MustacheUtils.applyTemplate((String)this.name, props);
    }

    public String getResolvedName(JReleaserContext context, Algorithm algorithm) {
        String resolvedName = context.getModel().getChecksum().getResolvedName(context);
        int pos = resolvedName.lastIndexOf(".");
        resolvedName = pos != -1 ? resolvedName.substring(0, pos) + "_" + algorithm.formatted() + resolvedName.substring(pos) : resolvedName + "." + algorithm.formatted();
        return resolvedName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean isIndividual() {
        return this.individual != null && this.individual != false;
    }

    public void setIndividual(Boolean individual) {
        this.individual = individual;
    }

    public boolean isIndividualSet() {
        return this.individual != null;
    }

    public Set<Algorithm> getAlgorithms() {
        return this.algorithms;
    }

    public void setAlgorithms(Set<Algorithm> algorithms) {
        this.algorithms.clear();
        this.algorithms.addAll(algorithms);
    }

    public Boolean isFiles() {
        return this.files == null || this.files != false;
    }

    public boolean isFilesSet() {
        return this.files != null;
    }

    public void setFiles(Boolean files) {
        this.files = files;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("name", this.name);
        props.put("individual", this.isIndividual());
        props.put("algorithms", this.algorithms);
        props.put("files", this.isFiles());
        return props;
    }
}

