/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Signing;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public abstract class SigningValidator
extends Validator {
    public static void validateSigning(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        if (mode == JReleaserContext.Mode.ASSEMBLE) {
            return;
        }
        context.getLogger().debug("signing");
        Signing signing = context.getModel().getSigning();
        if (!signing.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        if (!signing.isArmoredSet()) {
            signing.setArmored(true);
        }
        signing.setPassphrase(SigningValidator.checkProperty(context, "GPG_PASSPHRASE", "signing.passphrase", signing.getPassphrase(), errors, context.isDryrun()));
        if (signing.resolveMode() == Signing.Mode.COMMAND) {
            signing.setExecutable(SigningValidator.checkProperty(context, "GPG_EXECUTABLE", "signing.executable", signing.getExecutable(), "gpg" + (PlatformUtils.isWindows() ? ".exe" : "")));
            signing.setHomeDir(SigningValidator.checkProperty(context, "GPG_HOMEDIR", "signing.homeDir", signing.getHomeDir(), ""));
            signing.setKeyName(SigningValidator.checkProperty(context, "GPG_KEYNAME", "signing.keyName", signing.getKeyName(), ""));
            signing.setPublicKeyring(SigningValidator.checkProperty(context, "GPG_PUBLIC_KEYRING", "signing.publicKeyRing", signing.getPublicKeyring(), ""));
        } else {
            signing.setPublicKey(SigningValidator.checkProperty(context, "GPG_PUBLIC_KEY", "signing.publicKey", signing.getPublicKey(), errors, context.isDryrun()));
            signing.setSecretKey(SigningValidator.checkProperty(context, "GPG_SECRET_KEY", "signing.secretKey", signing.getSecretKey(), errors, context.isDryrun()));
        }
        if (context.isDryrun() && (StringUtils.isBlank((String)Env.resolve((String)"GPG_EXECUTABLE", (String)signing.getExecutable())) || StringUtils.isBlank((String)Env.resolve((String)"GPG_PASSPHRASE", (String)signing.getPassphrase())) || StringUtils.isBlank((String)Env.resolve((String)"GPG_PUBLIC_KEY", (String)signing.getPublicKey())) || StringUtils.isBlank((String)Env.resolve((String)"GPG_SECRET_KEY", (String)signing.getSecretKey())))) {
            signing.setActive(Active.NEVER);
            signing.disable();
        }
    }
}

