/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.tools;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.Scoop;
import org.jreleaser.model.tool.spi.ToolProcessingException;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.tools.AbstractRepositoryToolProcessor;
import org.jreleaser.util.MustacheUtils;

public class ScoopToolProcessor
extends AbstractRepositoryToolProcessor<Scoop> {
    public ScoopToolProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws ToolProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(distribution, props);
    }

    @Override
    protected void fillToolProperties(Map<String, Object> props, Distribution distribution) throws ToolProcessingException {
        GitService gitService = this.context.getModel().getRelease().getGitService();
        props.put("scoopBucketRepoUrl", gitService.getResolvedRepoUrl(this.context.getModel(), ((Scoop)this.tool).getBucket().getOwner(), ((Scoop)this.tool).getBucket().getResolvedName()));
        props.put("scoopBucketRepoCloneUrl", gitService.getResolvedRepoCloneUrl(this.context.getModel(), ((Scoop)this.tool).getBucket().getOwner(), ((Scoop)this.tool).getBucket().getResolvedName()));
        props.put("scoopCheckverUrl", this.resolveCheckverUrl(props));
        props.put("scoopAutoupdateUrl", this.resolveAutoupdateUrl(props));
    }

    private Object resolveCheckverUrl(Map<String, Object> props) {
        if (!((Scoop)this.getTool()).getCheckverUrl().contains("{{")) {
            return ((Scoop)this.getTool()).getCheckverUrl();
        }
        return MustacheUtils.applyTemplate((String)((Scoop)this.getTool()).getCheckverUrl(), props);
    }

    private Object resolveAutoupdateUrl(Map<String, Object> props) {
        if (!((Scoop)this.getTool()).getAutoupdateUrl().contains("{{")) {
            return ((Scoop)this.getTool()).getAutoupdateUrl();
        }
        String artifactFilename = (String)props.get("artifactFileName");
        String projectVersion = (String)props.get("projectVersion");
        String tagName = (String)props.get("tagName");
        artifactFilename = artifactFilename.replace(projectVersion, "$version");
        tagName = tagName.replace(projectVersion, "$version");
        LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(props);
        copy.put("projectVersion", "$version");
        copy.put("projectEffectiveVersion", "$version");
        copy.put("tagName", tagName);
        copy.put("artifactFileName", artifactFilename);
        return MustacheUtils.applyTemplate((String)((Scoop)this.getTool()).getAutoupdateUrl(), copy);
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws ToolProcessingException {
        Path outputFile = "manifest.json".equals(fileName = TemplateUtils.trimTplExtension((String)fileName)) ? outputDirectory.resolve("bucket").resolve(distribution.getExecutable().concat(".json")) : outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }
}

