/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.googlechat;

import java.util.LinkedHashMap;
import org.jreleaser.model.GoogleChat;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.announcer.spi.AnnounceException;
import org.jreleaser.model.announcer.spi.Announcer;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.googlechat.Message;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;

public class GoogleChatAnnouncer
implements Announcer {
    private final JReleaserContext context;

    GoogleChatAnnouncer(JReleaserContext context) {
        this.context = context;
    }

    public String getName() {
        return "googlechat";
    }

    public boolean isEnabled() {
        return this.context.getModel().getAnnounce().getGoogleChat().isEnabled();
    }

    public void announce() throws AnnounceException {
        String message;
        GoogleChat googleChat = this.context.getModel().getAnnounce().getGoogleChat();
        if (StringUtils.isNotBlank((String)googleChat.getMessage())) {
            message = googleChat.getResolvedMessage(this.context);
        } else {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            props.put("changelog", MustacheUtils.passThrough((String)this.context.getChangelog()));
            this.context.getModel().getRelease().getGitService().fillProps(props, this.context.getModel());
            message = googleChat.getResolvedMessageTemplate(this.context, props);
        }
        this.context.getLogger().info("message: {}", new Object[]{message});
        if (!this.context.isDryrun()) {
            ClientUtils.webhook((JReleaserLogger)this.context.getLogger(), (String)googleChat.getResolvedWebhook(), (int)googleChat.getConnectTimeout(), (int)googleChat.getReadTimeout(), (Object)Message.of(message));
        }
    }
}

