/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.util.Locale;
import javax.annotation.Nonnull;
import org.kohsuke.github.internal.EnumUtils;

public enum GHEvent {
    CHECK_RUN,
    CHECK_SUITE,
    CODE_SCANNING_ALERT,
    COMMIT_COMMENT,
    CONTENT_REFERENCE,
    CREATE,
    DELETE,
    DEPLOY_KEY,
    DEPLOYMENT,
    DEPLOYMENT_STATUS,
    DOWNLOAD,
    FOLLOW,
    FORK,
    FORK_APPLY,
    GITHUB_APP_AUTHORIZATION,
    GIST,
    GOLLUM,
    INSTALLATION,
    INSTALLATION_REPOSITORIES,
    INTEGRATION_INSTALLATION_REPOSITORIES,
    ISSUE_COMMENT,
    ISSUES,
    LABEL,
    MARKETPLACE_PURCHASE,
    MEMBER,
    MEMBERSHIP,
    META,
    MILESTONE,
    ORGANIZATION,
    ORG_BLOCK,
    PACKAGE,
    PAGE_BUILD,
    PROJECT_CARD,
    PROJECT_COLUMN,
    PROJECT,
    PING,
    PUBLIC,
    PULL_REQUEST,
    PULL_REQUEST_REVIEW,
    PULL_REQUEST_REVIEW_COMMENT,
    PUSH,
    REGISTRY_PACKAGE,
    RELEASE,
    REPOSITORY_DISPATCH,
    REPOSITORY,
    REPOSITORY_IMPORT,
    REPOSITORY_VULNERABILITY_ALERT,
    SCHEDULE,
    SECURITY_ADVISORY,
    STAR,
    STATUS,
    TEAM,
    TEAM_ADD,
    WATCH,
    WORKFLOW_DISPATCH,
    WORKFLOW_RUN,
    UNKNOWN,
    ALL;


    String symbol() {
        if (this == ALL) {
            return "*";
        }
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    static enum GitHubEventType {
        CommitCommentEvent(COMMIT_COMMENT),
        CreateEvent(CREATE),
        DeleteEvent(DELETE),
        ForkEvent(FORK),
        GollumEvent(GOLLUM),
        IssueCommentEvent(ISSUE_COMMENT),
        IssuesEvent(ISSUES),
        MemberEvent(MEMBER),
        PublicEvent(PUBLIC),
        PullRequestEvent(PULL_REQUEST),
        PullRequestReviewEvent(PULL_REQUEST_REVIEW),
        PullRequestReviewCommentEvent(PULL_REQUEST_REVIEW_COMMENT),
        PushEvent(PUSH),
        ReleaseEvent(RELEASE),
        WatchEvent(WATCH),
        UnknownEvent(UNKNOWN);

        private final GHEvent event;

        private GitHubEventType(GHEvent event) {
            this.event = event;
        }

        static GHEvent transformToGHEvent(@Nonnull String event) {
            return EnumUtils.getEnumOrDefault(GitHubEventType.class, (String)event, GitHubEventType.UnknownEvent).event;
        }
    }
}

