/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.assemblers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.jreleaser.assemblers.AbstractAssemblerProcessor;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Archive;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.assembler.spi.AssemblerProcessingException;
import org.jreleaser.util.FileUtils;

public class ArchiveAssemblerProcessor
extends AbstractAssemblerProcessor<Archive> {
    public ArchiveAssemblerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doAssemble(Map<String, Object> props) throws AssemblerProcessingException {
        Path assembleDirectory = (Path)props.get("distributionAssembleDirectory");
        String archiveName = ((Archive)this.assembler).getResolvedArchiveName(this.context);
        Path workDirectory = assembleDirectory.resolve("work");
        Path archiveDirectory = workDirectory.resolve(archiveName);
        try {
            FileUtils.deleteFiles((Path)workDirectory);
            Files.createDirectories(archiveDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_delete_archive", (Object[])new Object[]{archiveName}), (Throwable)e);
        }
        this.context.getLogger().debug(RB.$((String)"assembler.copy.files", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(archiveDirectory)});
        this.copyFileSets(this.context, archiveDirectory);
        for (Archive.Format format : ((Archive)this.assembler).getFormats()) {
            this.archive(workDirectory, assembleDirectory, archiveName, format);
        }
    }

    private void archive(Path workDirectory, Path assembleDirectory, String archiveName, Archive.Format format) throws AssemblerProcessingException {
        String finalArchiveName = archiveName + "." + format.extension();
        this.context.getLogger().info("- {}", new Object[]{finalArchiveName});
        try {
            Path archiveFile = assembleDirectory.resolve(finalArchiveName);
            switch (format) {
                case ZIP: {
                    FileUtils.zip((Path)workDirectory, (Path)archiveFile);
                    break;
                }
                case TAR: {
                    FileUtils.tar((Path)workDirectory, (Path)archiveFile);
                    break;
                }
                case TGZ: 
                case TAR_GZ: {
                    FileUtils.tgz((Path)workDirectory, (Path)archiveFile);
                    break;
                }
                case TXZ: 
                case TAR_XZ: {
                    FileUtils.xz((Path)workDirectory, (Path)archiveFile);
                    break;
                }
                case TBZ2: 
                case TAR_BZ2: {
                    FileUtils.bz2((Path)workDirectory, (Path)archiveFile);
                }
            }
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }
}

