/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public class Env {
    private static final String JRELEASER_ENV_PREFIX = "JRELEASER_";
    private static final String JRELEASER_SYS_PREFIX = "jreleaser.";

    public static String toVar(String str) {
        return str.replaceAll(" ", "_").replaceAll("-", "_").toUpperCase();
    }

    public static String envKey(String key) {
        if (!key.startsWith(JRELEASER_ENV_PREFIX)) {
            key = JRELEASER_ENV_PREFIX + key;
        }
        return key.replace(".", "_").toUpperCase(Locale.ENGLISH);
    }

    public static String sysKey(String key) {
        if (!key.startsWith(JRELEASER_SYS_PREFIX)) {
            key = JRELEASER_SYS_PREFIX + key;
        }
        return key.replace("_", ".").toLowerCase(Locale.ENGLISH);
    }

    public static String env(String key, String value) {
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        return System.getenv(Env.envKey(key));
    }

    public static String env(Collection<String> keys, String value) {
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        return keys.stream().map(Env::envKey).filter(key -> System.getenv().containsKey(key)).map(System::getenv).findFirst().orElse(null);
    }

    public static String sys(String key, String value) {
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        return System.getProperty(Env.sysKey(key));
    }

    public static String sys(Collection<String> keys, String value) {
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        return keys.stream().map(Env::sysKey).filter(key -> System.getProperties().containsKey(key)).map(System::getProperty).findFirst().orElse(null);
    }

    public static String resolve(String key, String value) {
        return Env.env(key, Env.sys(key, value));
    }

    public static String resolveOrDefault(String key, String value, String defaultValue) {
        String result = Env.env(key, Env.sys(key, value));
        return StringUtils.isNotBlank(result) ? result : defaultValue;
    }

    public static String check(String key, String value, String property, String dsl, String configFilePath, Errors errors) {
        String prefixedKey;
        if (StringUtils.isBlank(value) && StringUtils.isBlank(value = System.getenv(prefixedKey = Env.envKey(key)))) {
            errors.configuration(RB.$("ERROR_environment_property_check", property, dsl, prefixedKey, configFilePath, prefixedKey));
        }
        return value;
    }

    public static String check(Collection<String> keys, Properties values, String property, String dsl, String configFilePath, Errors errors) {
        List prefixedKeys = keys.stream().map(Env::envKey).collect(Collectors.toList());
        String value = prefixedKeys.stream().filter(values::containsKey).map(values::getProperty).findFirst().orElse(null);
        if (StringUtils.isBlank(value)) {
            errors.configuration(RB.$("ERROR_environment_property_check2", property, dsl, prefixedKeys, configFilePath, prefixedKeys));
        }
        return value;
    }
}

