/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.BaseBuilder;
import feign.Client;
import feign.ReflectiveFeign;
import feign.Response;
import feign.ResponseMapper;
import feign.SynchronousMethodHandler;
import feign.Target;
import feign.Types;
import feign.codec.Decoder;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public abstract class Feign {
    public static Builder builder() {
        return new Builder();
    }

    public static String configKey(Class targetType, Method method) {
        StringBuilder builder = new StringBuilder();
        builder.append(targetType.getSimpleName());
        builder.append('#').append(method.getName()).append('(');
        for (Type param : method.getGenericParameterTypes()) {
            param = Types.resolve(targetType, targetType, param);
            builder.append(Types.getRawType(param).getSimpleName()).append(',');
        }
        if (method.getParameterTypes().length > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.append(')').toString();
    }

    @Deprecated
    public static String configKey(Method method) {
        return Feign.configKey(method.getDeclaringClass(), method);
    }

    public abstract <T> T newInstance(Target<T> var1);

    public static class ResponseMappingDecoder
    implements Decoder {
        private final ResponseMapper mapper;
        private final Decoder delegate;

        public ResponseMappingDecoder(ResponseMapper mapper, Decoder decoder) {
            this.mapper = mapper;
            this.delegate = decoder;
        }

        @Override
        public Object decode(Response response, Type type) throws IOException {
            return this.delegate.decode(this.mapper.map(response, type), type);
        }
    }

    public static class Builder
    extends BaseBuilder<Builder> {
        private Client client = new Client.Default(null, null);
        private boolean forceDecoding = false;

        public Builder client(Client client) {
            this.client = client;
            return this;
        }

        Builder forceDecoding() {
            this.forceDecoding = true;
            return this;
        }

        public <T> T target(Class<T> apiType, String url) {
            return this.target(new Target.HardCodedTarget<T>(apiType, url));
        }

        public <T> T target(Target<T> target) {
            return this.build().newInstance(target);
        }

        public Feign build() {
            super.enrich();
            SynchronousMethodHandler.Factory synchronousMethodHandlerFactory = new SynchronousMethodHandler.Factory(this.client, this.retryer, this.requestInterceptors, this.responseInterceptor, this.logger, this.logLevel, this.dismiss404, this.closeAfterDecode, this.propagationPolicy, this.forceDecoding);
            ReflectiveFeign.ParseHandlersByName handlersByName = new ReflectiveFeign.ParseHandlersByName(this.contract, this.options, this.encoder, this.decoder, this.queryMapEncoder, this.errorDecoder, synchronousMethodHandlerFactory);
            return new ReflectiveFeign(handlersByName, this.invocationHandlerFactory, this.queryMapEncoder);
        }
    }
}

