/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.BiConsumer;
import org.jreleaser.bundle.RB;
import org.jreleaser.config.JReleaserConfigLoader;
import org.jreleaser.config.JReleaserConfigParser;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Domain;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public class Environment
extends AbstractModelObject<Environment>
implements Domain {
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    @JsonIgnore
    private final Map<String, Object> sourcedProperties = new LinkedHashMap<String, Object>();
    @JsonIgnore
    private PropertiesSource propertiesSource;
    private String variables;
    @JsonIgnore
    private Properties vars;
    @JsonIgnore
    private Path propertiesFile;

    @Override
    public void merge(Environment environment) {
        this.freezeCheck();
        this.variables = this.merge(this.variables, environment.variables);
        this.setProperties(this.merge(this.properties, environment.properties));
        this.setPropertiesSource(this.merge(this.propertiesSource, environment.propertiesSource));
    }

    public Properties getVars() {
        return this.freezeWrap(this.vars);
    }

    public String getVariable(String key) {
        return this.vars.getProperty(Env.envKey((String)key));
    }

    public boolean isSet() {
        return StringUtils.isNotBlank((String)this.variables) || !this.properties.isEmpty();
    }

    public PropertiesSource getPropertiesSource() {
        return this.propertiesSource;
    }

    public void setPropertiesSource(PropertiesSource propertiesSource) {
        this.freezeCheck();
        this.propertiesSource = propertiesSource;
        if (null != this.propertiesSource) {
            this.sourcedProperties.putAll(propertiesSource.getProperties());
        }
    }

    public String getVariables() {
        return this.variables;
    }

    public void setVariables(String variables) {
        this.freezeCheck();
        this.variables = variables;
    }

    public Map<String, Object> getProperties() {
        return this.freezeWrap(this.properties);
    }

    public void setProperties(Map<String, Object> properties) {
        this.freezeCheck();
        this.properties.putAll(properties);
    }

    public Map<String, Object> getSourcedProperties() {
        return this.freezeWrap(this.sourcedProperties);
    }

    public Path getPropertiesFile() {
        return this.propertiesFile;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("variables", this.variables);
        map.put("properties", this.properties);
        return map;
    }

    public void initProps(JReleaserContext context) {
        if (null == this.vars) {
            this.vars = new Properties();
            String home = System.getenv("JRELEASER_USER_HOME");
            if (StringUtils.isBlank((String)home)) {
                home = System.getProperty("user.home") + File.separator + ".jreleaser";
            }
            Path configDirectory = Paths.get(home, new String[0]);
            this.loadVariables(context, this.resolveConfigFileAt(configDirectory).orElse(configDirectory.resolve("config.properties")));
            if (StringUtils.isNotBlank((String)this.variables)) {
                this.loadVariables(context, context.getBasedir().resolve(this.variables.trim()));
            }
            if (null != this.propertiesSource) {
                this.sourcedProperties.putAll(this.propertiesSource.getProperties());
            }
        }
    }

    private void loadVariables(JReleaserContext context, Path file) {
        block10: {
            this.propertiesFile = file;
            context.getLogger().info(RB.$((String)"environment.load.variables", (Object[])new Object[0]), new Object[]{file.toAbsolutePath()});
            if (Files.exists(file, new LinkOption[0])) {
                try {
                    if (file.getFileName().toString().endsWith(".properties")) {
                        try (FileInputStream in = new FileInputStream(file.toFile());){
                            this.vars.load(in);
                            break block10;
                        }
                    }
                    this.vars.putAll(JReleaserConfigLoader.loadProperties(file));
                }
                catch (IOException e) {
                    context.getLogger().debug(RB.$((String)"environment.variables.load.error", (Object[])new Object[0]), new Object[]{file.toAbsolutePath(), e});
                }
            } else {
                context.getLogger().warn(RB.$((String)"environment.variables.source.missing", (Object[])new Object[0]), new Object[]{file.toAbsolutePath()});
            }
        }
    }

    private Optional<Path> resolveConfigFileAt(Path directory) {
        ServiceLoader<JReleaserConfigParser> parsers = ServiceLoader.load(JReleaserConfigParser.class, JReleaserConfigParser.class.getClassLoader());
        for (JReleaserConfigParser parser : parsers) {
            Path file = directory.resolve("config." + parser.getPreferredFileExtension());
            if (!Files.exists(file, new LinkOption[0])) continue;
            return Optional.of(file);
        }
        return Optional.empty();
    }

    public boolean getBooleanProperty(String key) {
        return this.properties.containsKey(key) && Boolean.parseBoolean(String.valueOf(this.properties.get(key))) || this.sourcedProperties.containsKey(key) && Boolean.parseBoolean(String.valueOf(this.sourcedProperties.get(key)));
    }

    public static class MapPropertiesSource
    extends AbstractPropertiesSource {
        private final Map<String, ?> properties;

        public MapPropertiesSource(Map<String, ?> properties) {
            this.properties = properties;
        }

        @Override
        protected Map<String, String> doGetProperties() {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            this.properties.forEach((k, v) -> map.put((String)k, String.valueOf(v)));
            return map;
        }
    }

    public static class PropertiesPropertiesSource
    extends AbstractPropertiesSource {
        private final Properties properties;

        public PropertiesPropertiesSource(Properties properties) {
            this.properties = properties;
        }

        @Override
        protected Map<String, String> doGetProperties() {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            this.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> map.put(String.valueOf(k), String.valueOf(v))));
            return map;
        }
    }

    public static abstract class AbstractPropertiesSource
    implements PropertiesSource {
        @Override
        public Map<String, String> getProperties() {
            Map<String, String> props = this.doGetProperties();
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            props.forEach((key, value) -> {
                if (key.startsWith("JRELEASER_")) {
                    return;
                }
                String k = key.replace(".", "-");
                k = StringUtils.getPropertyNameForLowerCaseHyphenSeparatedName((String)k);
                map.put(k, (String)value);
            });
            return map;
        }

        protected abstract Map<String, String> doGetProperties();
    }

    public static interface PropertiesSource {
        public Map<String, String> getProperties();
    }
}

