/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.AbstractUploader;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Ftp;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public class FtpUploader
extends AbstractUploader<FtpUploader>
implements Ftp {
    private String username;
    private String password;
    private String host;
    private Integer port;
    private String path;
    private String downloadUrl;

    public FtpUploader() {
        super("ftp");
    }

    @Override
    public void merge(FtpUploader ftp) {
        this.freezeCheck();
        super.merge(ftp);
        this.username = this.merge(this.username, ftp.username);
        this.password = this.merge(this.password, ftp.password);
        this.host = this.merge(this.host, ftp.host);
        this.port = this.merge(this.port, ftp.port);
        this.path = this.merge(this.path, ftp.path);
        this.downloadUrl = this.merge(this.downloadUrl, ftp.downloadUrl);
    }

    @Override
    public String getResolvedUsername() {
        return Env.env((String)("FTP_" + Env.toVar((String)this.name) + "_USERNAME"), (String)this.username);
    }

    @Override
    public String getResolvedPassword() {
        return Env.env((String)("FTP_" + Env.toVar((String)this.name) + "_PASSWORD"), (String)this.password);
    }

    @Override
    public String getResolvedHost() {
        return Env.env((String)("FTP_" + Env.toVar((String)this.name) + "_HOST"), (String)this.host);
    }

    @Override
    public Integer getResolvedPort() {
        String value = Env.env((String)("FTP_" + Env.toVar((String)this.name) + "_PORT"), (String)(null == this.port ? "" : String.valueOf(this.port)));
        return StringUtils.isBlank((String)value) ? 21 : Integer.parseInt(value);
    }

    public String getResolvedPath(JReleaserContext context, Artifact artifact) {
        Map p = this.artifactProps((Map)context.fullProps(), artifact);
        p.putAll(this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.path, (Map)p);
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, Artifact artifact) {
        return this.getResolvedDownloadUrl(context.fullProps(), artifact);
    }

    @Override
    public String getResolvedDownloadUrl(Map<String, Object> props, Artifact artifact) {
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>(this.artifactProps((Map)props, artifact));
        p.putAll(this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.downloadUrl, p);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.freezeCheck();
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.freezeCheck();
        this.password = password;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.freezeCheck();
        this.host = host;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public void setPort(Integer port) {
        this.freezeCheck();
        this.port = port;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.freezeCheck();
        this.path = path;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.freezeCheck();
        this.downloadUrl = downloadUrl;
    }

    @Override
    protected void asMap(Map<String, Object> props, boolean full) {
        props.put("host", this.getResolvedHost());
        props.put("port", this.getResolvedPort());
        props.put("username", StringUtils.isNotBlank((String)this.getResolvedUsername()) ? "************" : "**unset**");
        props.put("password", StringUtils.isNotBlank((String)this.getResolvedPassword()) ? "************" : "**unset**");
        props.put("path", this.path);
        props.put("downloadUrl", this.downloadUrl);
    }
}

