/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.validation.AnnouncersValidator;
import org.jreleaser.model.validation.AssemblersValidator;
import org.jreleaser.model.validation.ChecksumValidator;
import org.jreleaser.model.validation.DistributionsValidator;
import org.jreleaser.model.validation.DownloadersValidator;
import org.jreleaser.model.validation.FilesValidator;
import org.jreleaser.model.validation.PackagersValidator;
import org.jreleaser.model.validation.ProjectValidator;
import org.jreleaser.model.validation.ReleaseValidator;
import org.jreleaser.model.validation.SigningValidator;
import org.jreleaser.model.validation.UploadersValidator;
import org.jreleaser.util.Errors;

public final class JReleaserModelValidator {
    private JReleaserModelValidator() {
    }

    public static void validate(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().increaseIndent();
        context.getLogger().setPrefix("validation");
        try {
            JReleaserModelValidator.validateModel(context, mode, errors);
        }
        finally {
            context.getLogger().restorePrefix();
            context.getLogger().decreaseIndent();
        }
    }

    private static void validateModel(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        ProjectValidator.validateProject(context, mode, errors);
        DownloadersValidator.validateDownloaders(context, mode, errors);
        AssemblersValidator.validateAssemblers(context, mode, errors);
        if (context.getModel().getCommit() != null) {
            SigningValidator.validateSigning(context, mode, errors);
            ReleaseValidator.validateRelease(context, mode, errors);
        }
        ChecksumValidator.validateChecksum(context, mode, errors);
        UploadersValidator.validateUploaders(context, mode, errors);
        PackagersValidator.validatePackagers(context, mode, errors);
        DistributionsValidator.validateDistributions(context, mode, errors);
        FilesValidator.validateFiles(context, mode, errors);
        AnnouncersValidator.validateAnnouncers(context, mode, errors);
        ProjectValidator.postValidateProject(context, mode, errors);
        AssemblersValidator.postValidateAssemblers(context, mode, errors);
        if (!mode.validateStandalone()) {
            DistributionsValidator.postValidateDistributions(context, mode, errors);
        }
    }
}

