/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Domain;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public class Registry
extends AbstractModelObject<Registry>
implements Domain,
Comparable<Registry> {
    public static final String DEFAULT_NAME = "DEFAULT";
    protected String server;
    protected String serverName = "DEFAULT";
    protected String repositoryName;
    protected String username;
    protected String password;

    @Override
    public void merge(Registry registry) {
        this.freezeCheck();
        this.server = this.merge(this.server, registry.server);
        this.serverName = this.merge(this.serverName, registry.serverName);
        this.repositoryName = this.merge(this.repositoryName, registry.repositoryName);
        this.username = this.merge(this.username, registry.username);
        this.password = this.merge(this.password, registry.password);
    }

    public String getResolvedPassword() {
        return Env.env((String)("DOCKER_" + Env.toVar((String)this.serverName) + "_PASSWORD"), (String)this.password);
    }

    public String getResolvedUsername() {
        return Env.env((String)("DOCKER_" + Env.toVar((String)this.serverName) + "_USERNAME"), (String)this.username);
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.freezeCheck();
        this.server = server;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.freezeCheck();
        this.serverName = serverName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.freezeCheck();
        this.repositoryName = repositoryName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.freezeCheck();
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.freezeCheck();
        this.password = password;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("server", this.server);
        map.put("serverName", this.serverName);
        map.put("repositoryName", this.repositoryName);
        map.put("username", this.getResolvedUsername());
        map.put("password", StringUtils.isNotBlank((String)this.password) ? "************" : "**unset**");
        return map;
    }

    @Override
    public int compareTo(Registry o) {
        if (null == o) {
            return -1;
        }
        return this.serverName.compareTo(o.serverName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Registry that = (Registry)o;
        return this.serverName.equals(that.serverName);
    }

    public int hashCode() {
        return Objects.hash(this.serverName);
    }
}

