/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractPackager;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.TimeoutAware;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Env;
import org.jreleaser.util.FileType;
import org.jreleaser.util.StringUtils;

public class Sdkman
extends AbstractPackager<Sdkman>
implements TimeoutAware {
    public static final String SDKMAN_CONSUMER_KEY = "SDKMAN_CONSUMER_KEY";
    public static final String SDKMAN_CONSUMER_TOKEN = "SDKMAN_CONSUMER_TOKEN";
    public static final String TYPE = "sdkman";
    public static final String SKIP_SDKMAN = "skipSdkman";
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    protected Command command;
    private String candidate;
    private String releaseNotesUrl;
    private String consumerKey;
    private String consumerToken;
    private int connectTimeout;
    private int readTimeout;
    @JsonIgnore
    private boolean published;

    public Sdkman() {
        super(TYPE);
    }

    @Override
    public void merge(Sdkman sdkman) {
        this.freezeCheck();
        super.merge(sdkman);
        this.candidate = this.merge(this.candidate, sdkman.candidate);
        this.releaseNotesUrl = this.merge(this.releaseNotesUrl, sdkman.releaseNotesUrl);
        this.command = this.merge(this.command, sdkman.command);
        this.consumerKey = this.merge(this.consumerKey, sdkman.consumerKey);
        this.consumerToken = this.merge(this.consumerToken, sdkman.consumerToken);
        this.connectTimeout = this.merge(this.connectTimeout, sdkman.connectTimeout);
        this.readTimeout = this.merge(this.readTimeout, sdkman.readTimeout);
        this.published = this.merge(this.published, sdkman.published);
    }

    public String getResolvedConsumerKey() {
        return Env.env((String)SDKMAN_CONSUMER_KEY, (String)this.consumerKey);
    }

    public String getResolvedConsumerToken() {
        return Env.env((String)SDKMAN_CONSUMER_TOKEN, (String)this.consumerToken);
    }

    public String getCandidate() {
        return this.candidate;
    }

    public void setCandidate(String candidate) {
        this.freezeCheck();
        this.candidate = candidate;
    }

    public String getReleaseNotesUrl() {
        return this.releaseNotesUrl;
    }

    public void setReleaseNotesUrl(String releaseNotesUrl) {
        this.freezeCheck();
        this.releaseNotesUrl = releaseNotesUrl;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.freezeCheck();
        this.command = command;
    }

    public void setCommand(String str) {
        this.setCommand(Command.of(str));
    }

    public boolean isCommandSet() {
        return this.command != null;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.freezeCheck();
        this.consumerKey = consumerKey;
    }

    public String getConsumerToken() {
        return this.consumerToken;
    }

    public void setConsumerToken(String consumerToken) {
        this.freezeCheck();
        this.consumerToken = consumerToken;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.freezeCheck();
        this.connectTimeout = connectTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.freezeCheck();
        this.readTimeout = readTimeout;
    }

    public boolean isPublished() {
        return this.published;
    }

    public void setPublished(boolean published) {
        this.freezeCheck();
        this.published = published;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("candidate", this.candidate);
        props.put("command", (Object)this.command);
        props.put("releaseNotesUrl", this.releaseNotesUrl);
        props.put("connectTimeout", this.connectTimeout);
        props.put("readTimeout", this.readTimeout);
        props.put("consumerKey", StringUtils.isNotBlank((String)this.getResolvedConsumerKey()) ? "************" : "**unset**");
        props.put("consumerToken", StringUtils.isNotBlank((String)this.getResolvedConsumerToken()) ? "************" : "**unset**");
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return true;
    }

    @Override
    public boolean supportsDistribution(Distribution distribution) {
        return SUPPORTED.containsKey((Object)distribution.getType());
    }

    @Override
    public Set<String> getSupportedExtensions(Distribution distribution) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault((Object)distribution.getType(), Collections.emptySet()));
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get(SKIP_SDKMAN));
    }

    static {
        Set extensions = CollectionUtils.newSet((Object[])new String[]{FileType.ZIP.extension()});
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, extensions);
    }

    public static enum Command {
        MAJOR,
        MINOR;


        public String toString() {
            return this.name().toLowerCase();
        }

        public static Command of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return Command.valueOf(str.toUpperCase().trim());
        }
    }
}

