/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Activatable;
import org.jreleaser.model.Active;
import org.jreleaser.model.Domain;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public class Signing
extends AbstractModelObject<Signing>
implements Domain,
Activatable {
    public static final String KEY_SKIP_SIGNING = "skipSigning";
    public static final String COSIGN_PASSWORD = "COSIGN_PASSWORD";
    public static final String COSIGN_PRIVATE_KEY = "COSIGN_PRIVATE_KEY";
    public static final String COSIGN_PUBLIC_KEY = "COSIGN_PUBLIC_KEY";
    public static final String GPG_PASSPHRASE = "GPG_PASSPHRASE";
    public static final String GPG_PUBLIC_KEY = "GPG_PUBLIC_KEY";
    public static final String GPG_SECRET_KEY = "GPG_SECRET_KEY";
    public static final String GPG_EXECUTABLE = "GPG_EXECUTABLE";
    public static final String GPG_KEYNAME = "GPG_KEYNAME";
    public static final String GPG_HOMEDIR = "GPG_HOMEDIR";
    public static final String GPG_PUBLIC_KEYRING = "GPG_PUBLIC_KEYRING";
    private final Command command = new Command();
    private final Cosign cosign = new Cosign();
    private Active active;
    @JsonIgnore
    private boolean enabled;
    private Boolean armored;
    private String publicKey;
    private String secretKey;
    private String passphrase;
    private Mode mode;
    private Boolean artifacts;
    private Boolean files;
    private Boolean checksums;

    @Override
    public void freeze() {
        super.freeze();
        this.command.freeze();
        this.cosign.freeze();
    }

    @Override
    public void merge(Signing signing) {
        this.freezeCheck();
        this.active = this.merge(this.active, signing.active);
        this.enabled = this.merge(this.enabled, signing.enabled);
        this.armored = this.merge(this.armored, signing.armored);
        this.publicKey = this.merge(this.publicKey, signing.publicKey);
        this.secretKey = this.merge(this.secretKey, signing.secretKey);
        this.passphrase = this.merge(this.passphrase, signing.passphrase);
        this.mode = this.merge(this.mode, signing.mode);
        this.artifacts = this.merge(this.artifacts, signing.artifacts);
        this.files = this.merge(this.files, signing.files);
        this.checksums = this.merge(this.checksums, signing.checksums);
        this.setCommand(signing.command);
        this.setCosign(signing.cosign);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.setActive(Env.resolveOrDefault((String)"signing.active", (String)"", (String)"NEVER"));
        }
        this.enabled = this.active.check(project);
        return this.enabled;
    }

    public Mode resolveMode() {
        if (null == this.mode) {
            this.mode = Mode.MEMORY;
        }
        return this.mode;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.freezeCheck();
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of(str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    public String getResolvedPublicKey() {
        return Env.env((String)GPG_PUBLIC_KEY, (String)this.publicKey);
    }

    public String getResolvedSecretKey() {
        return Env.env((String)GPG_SECRET_KEY, (String)this.secretKey);
    }

    public String getResolvedPassphrase() {
        return Env.env((String)GPG_PASSPHRASE, (String)this.passphrase);
    }

    public String getResolvedCosignPassword() {
        return Env.env((String)COSIGN_PASSWORD, (String)this.passphrase);
    }

    public Boolean isArmored() {
        return this.armored != null && this.armored != false;
    }

    public void setArmored(Boolean armored) {
        this.freezeCheck();
        this.armored = armored;
    }

    public boolean isArmoredSet() {
        return this.armored != null;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.freezeCheck();
        this.publicKey = publicKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.freezeCheck();
        this.secretKey = secretKey;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.freezeCheck();
        this.passphrase = passphrase;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.freezeCheck();
        this.mode = mode;
    }

    public void setMode(String str) {
        this.setMode(Mode.of(str));
    }

    public boolean isArtifactsSet() {
        return this.artifacts != null;
    }

    public Boolean isArtifacts() {
        return this.artifacts == null || this.artifacts != false;
    }

    public void setArtifacts(Boolean artifacts) {
        this.freezeCheck();
        this.artifacts = artifacts;
    }

    public Boolean isFiles() {
        return this.files == null || this.files != false;
    }

    public boolean isFilesSet() {
        return this.files != null;
    }

    public void setFiles(Boolean files) {
        this.freezeCheck();
        this.files = files;
    }

    public boolean isChecksumsSet() {
        return this.checksums != null;
    }

    public Boolean isChecksums() {
        return this.checksums == null || this.checksums != false;
    }

    public void setChecksums(Boolean checksums) {
        this.freezeCheck();
        this.checksums = checksums;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.freezeCheck();
        this.command.merge(command);
    }

    public Cosign getCosign() {
        return this.cosign;
    }

    public void setCosign(Cosign cosign) {
        this.cosign.merge(cosign);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", (Object)this.active);
        props.put("armored", this.isArmored());
        props.put("mode", (Object)this.mode);
        props.put("artifacts", this.isArtifacts());
        props.put("files", this.isFiles());
        props.put("checksums", this.isChecksums());
        props.put("passphrase", StringUtils.isNotBlank((String)this.passphrase) ? "************" : "**unset**");
        if (this.mode == Mode.COMMAND) {
            props.put("command", this.command.asMap(full));
        } else if (this.mode == Mode.COSIGN) {
            props.put("cosign", this.cosign.asMap(full));
        } else {
            props.put("publicKey", StringUtils.isNotBlank((String)this.publicKey) ? "************" : "**unset**");
            props.put("secretKey", StringUtils.isNotBlank((String)this.secretKey) ? "************" : "**unset**");
        }
        return props;
    }

    public String getSignatureExtension() {
        String extension = ".sig";
        if (this.mode != Mode.COSIGN) {
            extension = this.isArmored() != false ? ".asc" : ".sig";
        }
        return extension;
    }

    public static class Cosign
    extends AbstractModelObject<Cosign>
    implements Domain {
        private String version;
        private String privateKeyFile;
        private String publicKeyFile;

        @Override
        public void merge(Cosign cosign) {
            this.freezeCheck();
            this.version = this.merge(this.version, cosign.version);
            this.privateKeyFile = this.merge(this.privateKeyFile, cosign.privateKeyFile);
            this.publicKeyFile = this.merge(this.publicKeyFile, cosign.publicKeyFile);
        }

        public String getResolvedPrivateKeyFile() {
            return Env.env((String)Signing.COSIGN_PRIVATE_KEY, (String)this.privateKeyFile);
        }

        public String getResolvedPublicKeyFile() {
            return Env.env((String)Signing.COSIGN_PUBLIC_KEY, (String)this.publicKeyFile);
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.freezeCheck();
            this.version = version;
        }

        public String getPrivateKeyFile() {
            return this.privateKeyFile;
        }

        public void setPrivateKeyFile(String privateKeyFile) {
            this.freezeCheck();
            this.privateKeyFile = privateKeyFile;
        }

        public String getPublicKeyFile() {
            return this.publicKeyFile;
        }

        public void setPublicKeyFile(String publicKeyFile) {
            this.freezeCheck();
            this.publicKeyFile = publicKeyFile;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("version", this.version);
            props.put("privateKeyFile", null != this.privateKeyFile ? "************" : "**unset**");
            props.put("publicKeyFile", this.publicKeyFile);
            return props;
        }

        public Path getResolvedPrivateKeyFilePath(JReleaserContext context) {
            String privateKey = this.getResolvedPrivateKeyFile();
            if (StringUtils.isNotBlank((String)privateKey)) {
                return context.getBasedir().resolve(privateKey);
            }
            return this.resolveJReleaserHomeDir().resolve("cosign.key");
        }

        public Path getResolvedPublicKeyFilePath(JReleaserContext context) {
            String publicKey = this.getResolvedPublicKeyFile();
            if (StringUtils.isNotBlank((String)publicKey)) {
                return context.getBasedir().resolve(publicKey);
            }
            return this.resolveJReleaserHomeDir().resolve("cosign.pub");
        }

        private Path resolveJReleaserHomeDir() {
            String home = System.getenv("JRELEASER_USER_HOME");
            if (StringUtils.isBlank((String)home)) {
                home = System.getProperty("user.home") + File.separator + ".jreleaser";
            }
            return Paths.get(home, new String[0]);
        }
    }

    public static class Command
    extends AbstractModelObject<Command>
    implements Domain {
        private final List<String> args = new ArrayList<String>();
        private String executable;
        private String keyName;
        private String homeDir;
        private String publicKeyring;
        private Boolean defaultKeyring;

        @Override
        public void merge(Command command) {
            this.freezeCheck();
            this.executable = this.merge(this.executable, command.executable);
            this.keyName = this.merge(this.keyName, command.keyName);
            this.homeDir = this.merge(this.homeDir, command.homeDir);
            this.publicKeyring = this.merge(this.publicKeyring, command.publicKeyring);
            this.defaultKeyring = this.merge(this.defaultKeyring, command.defaultKeyring);
            this.setArgs(this.merge(this.args, command.args));
        }

        public String getExecutable() {
            return this.executable;
        }

        public void setExecutable(String executable) {
            this.freezeCheck();
            this.executable = executable;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public void setKeyName(String keyName) {
            this.freezeCheck();
            this.keyName = keyName;
        }

        public String getHomeDir() {
            return this.homeDir;
        }

        public void setHomeDir(String homeDir) {
            this.freezeCheck();
            this.homeDir = homeDir;
        }

        public String getPublicKeyring() {
            return this.publicKeyring;
        }

        public void setPublicKeyring(String publicKeyring) {
            this.freezeCheck();
            this.publicKeyring = publicKeyring;
        }

        public boolean isDefaultKeyringSet() {
            return this.defaultKeyring != null;
        }

        public Boolean isDefaultKeyring() {
            return this.defaultKeyring == null || this.defaultKeyring != false;
        }

        public void setDefaultKeyring(Boolean defaultKeyring) {
            this.freezeCheck();
            this.defaultKeyring = defaultKeyring;
        }

        public List<String> getArgs() {
            return this.freezeWrap(this.args);
        }

        public void setArgs(List<String> args) {
            this.freezeCheck();
            this.args.clear();
            this.args.addAll(args);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("executable", this.executable);
            props.put("keyName", this.keyName);
            props.put("homeDir", this.homeDir);
            props.put("publicKeyring", this.publicKeyring);
            props.put("defaultKeyring", this.isDefaultKeyring());
            props.put("args", this.args);
            return props;
        }
    }

    public static enum Mode {
        MEMORY,
        FILE,
        COMMAND,
        COSIGN;


        public String toString() {
            return this.name().toLowerCase();
        }

        public static Mode of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return Mode.valueOf(str.toUpperCase().trim());
        }
    }
}

