/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.AbstractRepositoryPackager;
import org.jreleaser.model.AbstractRepositoryTap;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Domain;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class Snap
extends AbstractRepositoryPackager<Snap> {
    public static final String TYPE = "snap";
    public static final String SKIP_SNAP = "skipSnap";
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private final Set<String> localPlugs = new LinkedHashSet<String>();
    private final Set<String> localSlots = new LinkedHashSet<String>();
    private final List<Plug> plugs = new ArrayList<Plug>();
    private final List<Slot> slots = new ArrayList<Slot>();
    private final List<Architecture> architectures = new ArrayList<Architecture>();
    private final SnapTap snap = new SnapTap();
    private String packageName;
    private String base = "core20";
    private String grade = "stable";
    private String confinement = "strict";
    private String exportedLogin;
    private Boolean remoteBuild;

    public Snap() {
        super(TYPE);
    }

    @Override
    public void freeze() {
        super.freeze();
        this.plugs.forEach(AbstractModelObject::freeze);
        this.slots.forEach(AbstractModelObject::freeze);
        this.architectures.forEach(AbstractModelObject::freeze);
        this.snap.freeze();
    }

    @Override
    public void merge(Snap snap) {
        this.freezeCheck();
        super.merge(snap);
        this.packageName = this.merge(this.packageName, snap.packageName);
        this.base = this.merge(this.base, snap.base);
        this.grade = this.merge(this.grade, snap.grade);
        this.confinement = this.merge(this.confinement, snap.confinement);
        this.exportedLogin = this.merge(this.exportedLogin, snap.exportedLogin);
        this.remoteBuild = this.merge(this.remoteBuild, snap.remoteBuild);
        this.setLocalPlugs(this.merge(this.localPlugs, snap.localPlugs));
        this.setLocalSlots(this.merge(this.localSlots, snap.localSlots));
        this.setPlugs(this.merge(this.plugs, snap.plugs));
        this.setSlots(this.merge(this.slots, snap.slots));
        this.setArchitectures(this.merge(this.architectures, snap.architectures));
        this.setSnap(snap.snap);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.freezeCheck();
        this.packageName = packageName;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.freezeCheck();
        this.base = base;
    }

    public String getGrade() {
        return this.grade;
    }

    public void setGrade(String grade) {
        this.freezeCheck();
        this.grade = grade;
    }

    public String getConfinement() {
        return this.confinement;
    }

    public void setConfinement(String confinement) {
        this.freezeCheck();
        this.confinement = confinement;
    }

    public Set<String> getLocalPlugs() {
        return this.freezeWrap(this.localPlugs);
    }

    public void setLocalPlugs(Set<String> localPlugs) {
        this.freezeCheck();
        this.localPlugs.clear();
        this.localPlugs.addAll(localPlugs);
    }

    public Set<String> getLocalSlots() {
        return this.freezeWrap(this.localSlots);
    }

    public void setLocalSlots(Set<String> localSlots) {
        this.freezeCheck();
        this.localSlots.clear();
        this.localSlots.addAll(localSlots);
    }

    public List<Plug> getPlugs() {
        return this.freezeWrap(this.plugs);
    }

    public void setPlugs(List<Plug> plugs) {
        this.freezeCheck();
        this.plugs.clear();
        this.plugs.addAll(plugs);
    }

    public List<Slot> getSlots() {
        return this.freezeWrap(this.slots);
    }

    public void setSlots(List<Slot> slots) {
        this.freezeCheck();
        this.slots.clear();
        this.slots.addAll(slots);
    }

    public List<Architecture> getArchitectures() {
        return this.freezeWrap(this.architectures);
    }

    public void setArchitectures(List<Architecture> architectures) {
        this.freezeCheck();
        this.architectures.clear();
        this.architectures.addAll(architectures);
    }

    public void addArchitecture(List<Architecture> architectures) {
        this.freezeCheck();
        this.architectures.addAll(architectures);
    }

    public void addArchitecture(Architecture architecture) {
        this.freezeCheck();
        if (null != architecture) {
            this.architectures.add(architecture);
        }
    }

    public String getExportedLogin() {
        return this.exportedLogin;
    }

    public void setExportedLogin(String exportedLogin) {
        this.freezeCheck();
        this.exportedLogin = exportedLogin;
    }

    public boolean isRemoteBuild() {
        return this.remoteBuild != null && this.remoteBuild != false;
    }

    public void setRemoteBuild(Boolean remoteBuild) {
        this.freezeCheck();
        this.remoteBuild = remoteBuild;
    }

    public boolean isRemoteBuildSet() {
        return this.remoteBuild != null;
    }

    public SnapTap getSnap() {
        return this.snap;
    }

    public void setSnap(SnapTap snap) {
        this.snap.merge(snap);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        int i;
        super.asMap(full, props);
        props.put("packageName", this.packageName);
        props.put("base", this.base);
        props.put("grade", this.grade);
        props.put("confinement", this.confinement);
        props.put("exportedLogin", this.exportedLogin);
        props.put("remoteBuild", this.isRemoteBuild());
        props.put(TYPE, this.snap.asMap(full));
        props.put("localPlugs", this.localPlugs);
        props.put("localSlots", this.localSlots);
        LinkedHashMap<String, Map<String, Object>> mapped = new LinkedHashMap<String, Map<String, Object>>();
        for (i = 0; i < this.plugs.size(); ++i) {
            mapped.put("plug " + i, this.plugs.get(i).asMap(full));
        }
        props.put("plugs", mapped);
        mapped = new LinkedHashMap();
        for (i = 0; i < this.slots.size(); ++i) {
            mapped.put("slot " + i, this.slots.get(i).asMap(full));
        }
        props.put("slots", mapped);
        mapped = new LinkedHashMap();
        for (i = 0; i < this.architectures.size(); ++i) {
            mapped.put("architecture " + i, this.architectures.get(i).asMap(full));
        }
        props.put("architectures", mapped);
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.snap;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isUnix((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution distribution) {
        return SUPPORTED.containsKey((Object)distribution.getType());
    }

    @Override
    public Set<String> getSupportedExtensions(Distribution distribution) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault((Object)distribution.getType(), Collections.emptySet()));
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get(SKIP_SNAP));
    }

    static {
        Set extensions = CollectionUtils.newSet((Object[])new String[]{FileType.TAR_BZ2.extension(), FileType.TAR_GZ.extension(), FileType.TAR_XZ.extension(), FileType.TBZ2.extension(), FileType.TGZ.extension(), FileType.TXZ.extension(), FileType.TAR.extension()});
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_PACKAGE, CollectionUtils.newSet((Object[])new String[]{FileType.DEB.extension(), FileType.RPM.extension()}));
        SUPPORTED.put(Distribution.DistributionType.SINGLE_JAR, CollectionUtils.newSet((Object[])new String[]{FileType.JAR.extension()}));
    }

    public static class Architecture
    extends AbstractModelObject<Architecture>
    implements Domain {
        private final List<String> buildOn = new ArrayList<String>();
        private final List<String> runOn = new ArrayList<String>();
        private Boolean ignoreError;

        @Override
        public void merge(Architecture source) {
            this.ignoreError = this.merge(this.ignoreError, source.ignoreError);
            this.setBuildOn(this.merge(this.buildOn, source.buildOn));
            this.setRunOn(this.merge(this.runOn, source.runOn));
        }

        public List<String> getBuildOn() {
            return this.freezeWrap(this.buildOn);
        }

        public void setBuildOn(List<String> buildOn) {
            this.freezeCheck();
            this.buildOn.clear();
            this.buildOn.addAll(buildOn);
        }

        public List<String> getRunOn() {
            return this.freezeWrap(this.runOn);
        }

        public void setRunOn(List<String> runOn) {
            this.freezeCheck();
            this.runOn.clear();
            this.runOn.addAll(runOn);
        }

        public boolean hasBuildOn() {
            return !this.buildOn.isEmpty();
        }

        public boolean hasRunOn() {
            return !this.runOn.isEmpty();
        }

        public boolean isIgnoreError() {
            return this.ignoreError != null && this.ignoreError != false;
        }

        public void setIgnoreError(Boolean ignoreError) {
            this.freezeCheck();
            this.ignoreError = ignoreError;
        }

        public boolean isIgnoreErrorSet() {
            return this.ignoreError != null;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("buildOn", this.buildOn);
            map.put("runOn", this.runOn);
            map.put("ignoreError", this.isIgnoreError());
            return map;
        }
    }

    public static class SnapTap
    extends AbstractRepositoryTap<SnapTap> {
        public SnapTap() {
            super(Snap.TYPE, Snap.TYPE);
        }
    }

    public static class Plug
    extends AbstractModelObject<Plug>
    implements Domain {
        private final Map<String, String> attributes = new LinkedHashMap<String, String>();
        private final List<String> reads = new ArrayList<String>();
        private final List<String> writes = new ArrayList<String>();
        private String name;

        @Override
        public void merge(Plug source) {
            this.name = this.merge(this.name, source.name);
            this.setAttributes(this.merge(this.attributes, source.attributes));
            this.setReads(this.merge(this.reads, source.reads));
            this.setWrites(this.merge(this.writes, source.writes));
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.freezeCheck();
            this.name = name;
        }

        public Map<String, String> getAttributes() {
            return this.freezeWrap(this.attributes);
        }

        public void setAttributes(Map<String, String> attributes) {
            this.freezeCheck();
            this.attributes.clear();
            this.attributes.putAll(attributes);
        }

        public Collection<Attribute> getAttrs() {
            return this.attributes.entrySet().stream().map(e -> new Attribute((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        }

        public List<String> getReads() {
            return this.freezeWrap(this.reads);
        }

        public void setReads(List<String> reads) {
            this.freezeCheck();
            this.reads.clear();
            this.reads.addAll(reads);
        }

        public List<String> getWrites() {
            return this.freezeWrap(this.writes);
        }

        public void setWrites(List<String> writes) {
            this.freezeCheck();
            this.writes.clear();
            this.writes.addAll(writes);
        }

        public boolean getHasRead() {
            return !this.reads.isEmpty();
        }

        public boolean getHasWrite() {
            return !this.writes.isEmpty();
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(this.name, this.attributes);
            map.put("reads", this.reads);
            map.put("writes", this.writes);
            return map;
        }

        public static Plug copyOf(Plug other) {
            Plug copy = new Plug();
            copy.setName(other.getName());
            copy.setAttributes(other.getAttributes());
            copy.setReads(other.getReads());
            copy.setWrites(other.getWrites());
            return copy;
        }
    }

    public static class Slot
    extends AbstractModelObject<Slot>
    implements Domain {
        private final Map<String, String> attributes = new LinkedHashMap<String, String>();
        private final List<String> reads = new ArrayList<String>();
        private final List<String> writes = new ArrayList<String>();
        private String name;

        @Override
        public void merge(Slot source) {
            this.name = this.merge(this.name, source.name);
            this.setAttributes(this.merge(this.attributes, source.attributes));
            this.setReads(this.merge(this.reads, source.reads));
            this.setWrites(this.merge(this.writes, source.writes));
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.freezeCheck();
            this.name = name;
        }

        public Map<String, String> getAttributes() {
            return this.freezeWrap(this.attributes);
        }

        public void setAttributes(Map<String, String> attributes) {
            this.freezeCheck();
            this.attributes.clear();
            this.attributes.putAll(attributes);
        }

        public Collection<Attribute> getAttrs() {
            return this.attributes.entrySet().stream().map(e -> new Attribute((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        }

        public List<String> getReads() {
            return this.freezeWrap(this.reads);
        }

        public void setReads(List<String> reads) {
            this.freezeCheck();
            this.reads.clear();
            this.reads.addAll(reads);
        }

        public List<String> getWrites() {
            return this.freezeWrap(this.writes);
        }

        public void setWrites(List<String> writes) {
            this.freezeCheck();
            this.writes.clear();
            this.writes.addAll(writes);
        }

        public boolean getHasReads() {
            return !this.reads.isEmpty();
        }

        public boolean getHasWrites() {
            return !this.writes.isEmpty();
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(this.name, this.attributes);
            map.put("read", this.reads);
            map.put("write", this.writes);
            return map;
        }

        public static Slot copyOf(Slot other) {
            Slot copy = new Slot();
            copy.setName(other.getName());
            copy.setAttributes(other.getAttributes());
            copy.setReads(other.getReads());
            copy.setWrites(other.getWrites());
            return copy;
        }
    }

    public static class Attribute {
        public final String key;
        public final String value;

        public Attribute(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

