/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import org.jreleaser.model.Download;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.validation.FtpDownloaderValidator;
import org.jreleaser.model.validation.HttpDownloaderValidator;
import org.jreleaser.model.validation.ScpDownloaderValidator;
import org.jreleaser.model.validation.SftpDownloaderValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;

public abstract class DownloadersValidator
extends Validator {
    public static void validateDownloaders(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        if (mode == JReleaserContext.Mode.CHANGELOG) {
            return;
        }
        context.getLogger().debug("download");
        Download download = context.getModel().getDownload();
        FtpDownloaderValidator.validateFtpDownloader(context, mode, errors);
        HttpDownloaderValidator.validateHttpDownloader(context, mode, errors);
        ScpDownloaderValidator.validateScpDownloader(context, mode, errors);
        SftpDownloaderValidator.validateSftpDownloader(context, mode, errors);
        boolean activeSet = download.isActiveSet();
        if (mode.validateConfig() || mode.validateDownload()) {
            download.resolveEnabled(context.getModel().getProject());
        }
        if (download.isEnabled()) {
            boolean enabled;
            boolean bl = enabled = !download.getActiveFtps().isEmpty() || !download.getActiveHttps().isEmpty() || !download.getActiveScps().isEmpty() || !download.getActiveSftps().isEmpty();
            if (!activeSet && !enabled) {
                download.disable();
            }
        }
    }
}

