/*
 * Decompiled with CFR 0.152.
 */
package org.nibor.autolink.internal;

import org.nibor.autolink.LinkSpan;
import org.nibor.autolink.LinkType;
import org.nibor.autolink.internal.LinkSpanImpl;
import org.nibor.autolink.internal.Scanner;
import org.nibor.autolink.internal.Scanners;

public class WwwScanner
implements Scanner {
    @Override
    public LinkSpan scan(CharSequence input, int triggerIndex, int rewindIndex) {
        int afterDot = triggerIndex + 4;
        if (afterDot >= input.length() || !WwwScanner.isWww(input, triggerIndex)) {
            return null;
        }
        int first = WwwScanner.findFirst(input, triggerIndex, rewindIndex);
        if (first == -1) {
            return null;
        }
        int last = WwwScanner.findLast(input, afterDot);
        if (last == -1) {
            return null;
        }
        return new LinkSpanImpl(LinkType.WWW, first, last + 1);
    }

    private static int findFirst(CharSequence input, int beginIndex, int rewindIndex) {
        if (beginIndex == rewindIndex) {
            return beginIndex;
        }
        if (WwwScanner.isAllowed(input.charAt(beginIndex - 1))) {
            return beginIndex;
        }
        return -1;
    }

    private static int findLast(CharSequence input, int beginIndex) {
        int last = Scanners.findUrlEnd(input, beginIndex);
        if (last == -1) {
            return -1;
        }
        int pointer = last;
        while (--pointer > beginIndex) {
            if (input.charAt(pointer) != '.' || pointer <= beginIndex) continue;
            return last;
        }
        return -1;
    }

    private static boolean isAllowed(char c) {
        return c != '.' && !Scanners.isAlnum(c);
    }

    private static boolean isWww(CharSequence input, int triggerIndex) {
        return input.charAt(triggerIndex + 1) == 'w' && input.charAt(triggerIndex + 2) == 'w' && input.charAt(triggerIndex + 3) == '.';
    }
}

