/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.function.Predicate;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.lib.GpgObjectSigner;
import org.eclipse.jgit.lib.GpgSigner;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.api.common.ExtraProperties;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.RepositoryPackager;
import org.jreleaser.model.internal.packagers.RepositoryTap;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.model.spi.release.Repository;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.packagers.AbstractTemplatePackagerProcessor;
import org.jreleaser.sdk.git.JReleaserGpgSigner;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.StringUtils;

public abstract class AbstractRepositoryPackagerProcessor<T extends RepositoryPackager<?>>
extends AbstractTemplatePackagerProcessor<T> {
    protected AbstractRepositoryPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPublishDistribution(Distribution distribution, TemplateContext props) throws PackagerProcessingException {
        RepositoryTap tap = ((RepositoryPackager)this.packager).getRepositoryTap();
        if (!tap.isEnabled()) {
            this.context.getLogger().info(RB.$((String)"repository.disabled", (Object[])new Object[0]), new Object[]{tap.getCanonicalRepoName()});
            return;
        }
        this.context.getLogger().info(RB.$((String)"repository.setup", (Object[])new Object[0]), new Object[]{tap.getCanonicalRepoName()});
        if (this.context.isDryrun()) {
            return;
        }
        BaseReleaser releaser = this.context.getModel().getRelease().getReleaser();
        String target = tap.getCanonicalRepoName();
        try {
            boolean mustBranch;
            this.context.getLogger().debug(RB.$((String)"repository.locate", (Object[])new Object[0]), new Object[]{tap.getCanonicalRepoName()});
            Repository repository = this.context.getReleaser().maybeCreateRepository(tap.getOwner(), tap.getResolvedName(), this.resolveGitToken(releaser), (ExtraProperties)tap.asImmutable());
            UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider(this.resolveGitUsername(releaser), this.resolveGitToken(releaser));
            target = repository.getHttpUrl();
            this.context.getLogger().debug(RB.$((String)"repository.clone", (Object[])new Object[0]), new Object[]{repository.getHttpUrl()});
            Path directory = Files.createTempDirectory("jreleaser-" + tap.getResolvedName(), new FileAttribute[0]);
            String pullBranch = tap.getBranch();
            String pushBranch = Templates.resolveTemplate((String)tap.getBranchPush(), (TemplateContext)props);
            Git git = ((CloneCommand)Git.cloneRepository().setCredentialsProvider((CredentialsProvider)credentialsProvider)).setBranch(pullBranch).setDirectory(directory.toFile()).setURI(repository.getHttpUrl()).call();
            boolean emptyRepository = true;
            try {
                Iterator iterator = git.log().call().iterator();
                if (iterator.hasNext()) {
                    RevCommit commit = (RevCommit)iterator.next();
                    emptyRepository = false;
                }
            }
            catch (NoHeadException noHeadException) {
                // empty catch block
            }
            boolean bl = mustBranch = !pushBranch.equals(pullBranch);
            if (mustBranch && !emptyRepository) {
                this.context.getLogger().debug(RB.$((String)"repository.branching", (Object[])new Object[]{pushBranch}));
                git.checkout().setName(pushBranch).setCreateBranch(true).call();
            }
            this.prepareWorkingCopy(props, directory, distribution);
            git.add().addFilepattern(".").call();
            props.setAll(distribution.props());
            this.context.getModel().getRelease().getReleaser().fillProps(props, this.context.getModel());
            this.context.getLogger().debug(RB.$((String)"repository.commit.setup", (Object[])new Object[0]));
            CommitCommand commitCommand = git.commit().setAll(true).setMessage(((RepositoryPackager)this.packager).getRepositoryTap().getResolvedCommitMessage(props)).setAuthor(((RepositoryPackager)this.packager).getCommitAuthor().getName(), ((RepositoryPackager)this.packager).getCommitAuthor().getEmail());
            commitCommand.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            boolean signingEnabled = releaser.isSign();
            String signingKey = "**********";
            JReleaserGpgSigner signer = new JReleaserGpgSigner(this.context, signingEnabled);
            commitCommand = commitCommand.setSign(Boolean.valueOf(signingEnabled)).setSigningKey(signingKey).setGpgSigner((GpgSigner)signer);
            commitCommand.call();
            if (mustBranch && emptyRepository) {
                this.context.getLogger().debug(RB.$((String)"repository.branching", (Object[])new Object[]{pushBranch}));
                git.checkout().setName(pushBranch).setCreateBranch(true).call();
            }
            String tagName = tap.getResolvedTagName(props);
            this.context.getLogger().debug(RB.$((String)"git.releaser.repository.tag", (Object[])new Object[0]), new Object[]{tagName});
            git.tag().setSigned(signingEnabled).setSigningKey(signingKey).setGpgSigner((GpgObjectSigner)signer).setName(tagName).setForceUpdate(true).call();
            this.context.getLogger().info(RB.$((String)"repository.push", (Object[])new Object[0]), new Object[]{target});
            this.context.getLogger().debug(RB.$((String)"repository.commit.push", (Object[])new Object[0]));
            ((PushCommand)git.push().setDryRun(false).setPushAll().setCredentialsProvider((CredentialsProvider)credentialsProvider)).setPushTags().call();
        }
        catch (Exception e) {
            throw new PackagerProcessingException(RB.$((String)"ERROR_unexpected_repository_update", (Object[])new Object[]{target}), (Throwable)e);
        }
    }

    protected void prepareWorkingCopy(TemplateContext props, Path directory, Distribution distribution) throws IOException {
        Path packageDirectory = (Path)props.get("distributionPackageDirectory");
        this.prepareWorkingCopy(packageDirectory, directory);
    }

    protected void prepareWorkingCopy(Path source, Path destination) throws IOException {
        this.context.getLogger().debug(RB.$((String)"repository.copy.files", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(source)});
        if (!FileUtils.copyFilesRecursive((JReleaserLogger)this.context.getLogger(), (Path)source, (Path)destination)) {
            throw new IOException(RB.$((String)"ERROR_repository_copy_files", (Object[])new Object[]{this.context.relativizeToBasedir(source)}));
        }
    }

    protected void prepareWorkingCopy(Path source, Path destination, Predicate<Path> filter) throws IOException {
        this.context.getLogger().debug(RB.$((String)"repository.copy.files", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(source)});
        if (!FileUtils.copyFilesRecursive((JReleaserLogger)this.context.getLogger(), (Path)source, (Path)destination, filter)) {
            throw new IOException(RB.$((String)"ERROR_repository_copy_files", (Object[])new Object[]{this.context.relativizeToBasedir(source)}));
        }
    }

    protected String resolveGitUsername(BaseReleaser<?, ?> releaser) {
        String username = ((RepositoryPackager)this.packager).getRepositoryTap().getUsername();
        return StringUtils.isNotBlank((String)username) ? username : releaser.getUsername();
    }

    protected String resolveGitToken(BaseReleaser<?, ?> releaser) {
        String token = ((RepositoryPackager)this.packager).getRepositoryTap().getToken();
        return StringUtils.isNotBlank((String)token) ? token : releaser.getToken();
    }
}

