/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.assemblers;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.jreleaser.assemblers.SwidTagGenerator;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.Assembler;
import org.jreleaser.model.internal.catalog.swid.SwidTag;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.FileSet;
import org.jreleaser.model.internal.common.Glob;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.util.Artifacts;
import org.jreleaser.model.spi.assemble.AssemblerProcessingException;
import org.jreleaser.model.spi.assemble.AssemblerProcessor;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.sdk.command.Command;
import org.jreleaser.sdk.command.CommandException;
import org.jreleaser.sdk.command.CommandExecutor;
import org.jreleaser.templates.TemplateResource;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public abstract class AbstractAssemblerProcessor<A extends org.jreleaser.model.api.assemble.Assembler, S extends Assembler<A>>
implements AssemblerProcessor<A, S> {
    public static final String BIN_DIRECTORY = "bin";
    public static final String LICENSE = "LICENSE";
    public static final String UNIVERSAL_DIRECTORY = "universal";
    public static final String INPUTS_DIRECTORY = "inputs";
    public static final String WORK_DIRECTORY = "work";
    public static final String JARS_DIRECTORY = "jars";
    public static final String ARCHIVE_DIRECTORY = "archive";
    protected final JReleaserContext context;
    protected S assembler;

    protected AbstractAssemblerProcessor(JReleaserContext context) {
        this.context = context;
    }

    public S getAssembler() {
        return this.assembler;
    }

    public void setAssembler(S assembler) {
        this.assembler = assembler;
    }

    public void assemble(TemplateContext props) throws AssemblerProcessingException {
        try {
            this.context.getLogger().debug(RB.$((String)"packager.create.properties", (Object[])new Object[0]), new Object[]{this.assembler.getType(), this.assembler.getName()});
            TemplateContext newProps = this.fillProps(props);
            Path assembleDirectory = (Path)props.get("distributionAssembleDirectory");
            Files.createDirectories(assembleDirectory, new FileAttribute[0]);
            this.doAssemble(newProps);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new AssemblerProcessingException((Throwable)e);
        }
    }

    protected abstract void doAssemble(TemplateContext var1) throws AssemblerProcessingException;

    protected void writeFile(String content, Path outputFile) throws AssemblerProcessingException {
        try {
            FileUtils.createDirectoriesWithFullAccess((Path)outputFile.getParent());
            Files.write(outputFile, content.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            FileUtils.grantFullAccess((Path)outputFile);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error_writing_file", (Object[])new Object[]{outputFile.toAbsolutePath()}), (Throwable)e);
        }
    }

    protected void writeFile(byte[] content, Path outputFile) throws AssemblerProcessingException {
        try {
            FileUtils.createDirectoriesWithFullAccess((Path)outputFile.getParent());
            Files.write(outputFile, content, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            FileUtils.grantFullAccess((Path)outputFile);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error_writing_file", (Object[])new Object[]{outputFile.toAbsolutePath()}), (Throwable)e);
        }
    }

    protected TemplateContext fillProps(TemplateContext props) {
        TemplateContext newProps = new TemplateContext(props);
        this.context.getLogger().debug(RB.$((String)"packager.fill.git.properties", (Object[])new Object[0]));
        BaseReleaser releaser = this.context.getModel().getRelease().getReleaser();
        if (null != releaser) {
            releaser.fillProps(newProps, this.context.getModel());
        }
        this.context.getLogger().debug(RB.$((String)"assembler.fill.assembler.properties", (Object[])new Object[0]));
        this.fillAssemblerProperties(newProps);
        MustacheUtils.applyTemplates((TemplateContext)props, (TemplateContext)props);
        return newProps;
    }

    protected void fillAssemblerProperties(TemplateContext props) {
        props.setAll(this.assembler.props());
    }

    protected Command.Result executeCommand(Path directory, Command command) throws AssemblerProcessingException {
        try {
            Command.Result result = new CommandExecutor(this.context.getLogger()).executeCommand(directory, command);
            if (result.getExitValue() != 0) {
                throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{result.getExitValue()}));
            }
            return result;
        }
        catch (CommandException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected Command.Result executeCommand(Command command) throws AssemblerProcessingException {
        try {
            Command.Result result = new CommandExecutor(this.context.getLogger()).executeCommand(command);
            if (result.getExitValue() != 0) {
                throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{result.getExitValue()}));
            }
            return result;
        }
        catch (CommandException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void copyTemplates(JReleaserContext context, TemplateContext props, Path targetDirectory) throws AssemblerProcessingException {
        try {
            context.getLogger().debug(RB.$((String)"packager.resolve.templates", (Object[])new Object[0]), new Object[]{this.assembler.getType(), this.assembler.getName()});
            Map templates = TemplateUtils.resolveAndMergeTemplates((JReleaserLogger)context.getLogger(), (String)this.assembler.getType(), (String)this.assembler.getType(), (boolean)context.getModel().getProject().isSnapshot(), (Path)context.getBasedir().resolve(this.getAssembler().getTemplateDirectory()));
            templates.putAll(TemplateUtils.resolveTemplates((Path)context.getBasedir().resolve(this.getAssembler().getTemplateDirectory())));
            for (Map.Entry entry : templates.entrySet()) {
                String filename = (String)entry.getKey();
                if (this.isSkipped(filename)) {
                    context.getLogger().debug(RB.$((String)"packager.skipped.template", (Object[])new Object[0]), new Object[]{filename, this.assembler.getType(), this.assembler.getName()});
                    continue;
                }
                TemplateResource value = (TemplateResource)entry.getValue();
                if (value.isReader()) {
                    context.getLogger().debug(RB.$((String)"packager.evaluate.template", (Object[])new Object[0]), new Object[]{filename, this.assembler.getName(), this.assembler.getType()});
                    String content = MustacheUtils.applyTemplate((Reader)value.getReader(), (TemplateContext)props, (String)filename);
                    context.getLogger().debug(RB.$((String)"packager.write.template", (Object[])new Object[0]), new Object[]{filename, this.assembler.getName(), this.assembler.getType()});
                    this.writeFile(content, props, targetDirectory, filename);
                    continue;
                }
                context.getLogger().debug(RB.$((String)"packager.write.template", (Object[])new Object[0]), new Object[]{filename, this.assembler.getName(), this.assembler.getType()});
                this.writeFile(IOUtils.toByteArray((InputStream)value.getInputStream()), props, targetDirectory, filename);
            }
        }
        catch (IOException | IllegalArgumentException e) {
            throw new AssemblerProcessingException((Throwable)e);
        }
    }

    protected void writeFile(byte[] content, TemplateContext props, Path targetDirectory, String fileName) throws AssemblerProcessingException {
        try {
            Files.createDirectories(targetDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_create_directories", (Object[])new Object[0]), (Throwable)e);
        }
        Path outputFile = targetDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }

    protected void writeFile(String content, TemplateContext props, Path targetDirectory, String fileName) throws AssemblerProcessingException {
        fileName = TemplateUtils.trimTplExtension((String)fileName);
        try {
            Files.createDirectories(targetDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_create_directories", (Object[])new Object[0]), (Throwable)e);
        }
        Path outputFile = this.resolveOutputFile(props, targetDirectory, fileName);
        this.writeFile(content, outputFile);
    }

    protected Path resolveOutputFile(TemplateContext props, Path targetDirectory, String fileName) throws AssemblerProcessingException {
        return targetDirectory.resolve(fileName);
    }

    protected void copyArtifacts(JReleaserContext context, Path destination, String platformConstraint, boolean filterByPlatform) throws AssemblerProcessingException {
        try {
            Files.createDirectories(destination, new FileAttribute[0]);
            for (Artifact artifact : this.assembler.getArtifacts()) {
                if (!artifact.resolveEnabled(context.getModel().getProject())) continue;
                Path incoming = artifact.getResolvedPath(context, this.assembler);
                if (artifact.isOptional(context) && !artifact.resolvedPathExists()) continue;
                String platform = artifact.getPlatform();
                if (filterByPlatform && StringUtils.isNotBlank((String)platformConstraint) && StringUtils.isNotBlank((String)platform) && !PlatformUtils.isCompatible((String)platformConstraint, (String)platform)) {
                    context.getLogger().debug(RB.$((String)"assembler.artifact.filter", (Object[])new Object[0]), new Object[]{incoming.getFileName()});
                    continue;
                }
                Path outgoing = incoming.getFileName();
                String transform = artifact.getTransform();
                if (StringUtils.isNotBlank((String)transform)) {
                    if (transform.startsWith("/")) {
                        transform = transform.substring(1);
                    }
                    outgoing = Paths.get(Artifacts.resolveForArtifact((String)transform, (JReleaserContext)context, (Artifact)artifact, this.assembler), new String[0]);
                }
                outgoing = destination.resolve(outgoing);
                Files.createDirectories(outgoing.getParent(), new FileAttribute[0]);
                context.getLogger().debug(RB.$((String)"assembler.copying", (Object[])new Object[0]), new Object[]{incoming.getFileName()});
                Files.copy(incoming, outgoing, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_copying_files", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void copyFiles(JReleaserContext context, Path destination) throws AssemblerProcessingException {
        LinkedHashSet paths = new LinkedHashSet();
        for (Glob glob : this.assembler.getFiles()) {
            if (!glob.resolveActiveAndSelected(context)) continue;
            glob.getResolvedArtifacts(context).stream().map(artifact -> artifact.getResolvedPath(context, this.assembler)).forEach(paths::add);
        }
        try {
            Files.createDirectories(destination, new FileAttribute[0]);
            for (Path path : paths) {
                context.getLogger().debug(RB.$((String)"assembler.copying", (Object[])new Object[0]), new Object[]{path.getFileName()});
                Files.copy(path, destination.resolve(path.getFileName()), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_copying_files", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void copyFileSets(JReleaserContext context, Path destination) throws AssemblerProcessingException {
        try {
            for (FileSet fileSet : this.assembler.getFileSets()) {
                if (!fileSet.resolveActiveAndSelected(context)) continue;
                Path src = context.getBasedir().resolve(fileSet.getResolvedInput(context));
                Path dest = destination;
                String output = fileSet.getResolvedOutput(context);
                if (StringUtils.isNotBlank((String)output)) {
                    dest = destination.resolve(output);
                }
                Set paths = fileSet.getResolvedPaths(context);
                FileUtils.copyFiles((JReleaserLogger)context.getLogger(), (Path)src, (Path)dest, (Set)paths);
            }
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_copying_files", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void generateSwidTag(JReleaserContext context, Path archiveDirectory) throws AssemblerProcessingException {
        SwidTag swidTag = this.assembler.getSwid();
        if (!swidTag.isEnabled()) {
            return;
        }
        context.getLogger().info(RB.$((String)"assembler.swid.tag", (Object[])new Object[0]), new Object[]{swidTag.getName()});
        try {
            SwidTagGenerator.generateTag(context, archiveDirectory, swidTag);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assemble_swid_tag", (Object[])new Object[]{swidTag.getName()}), (Throwable)e);
        }
    }

    protected String maybeQuote(String str) {
        return PlatformUtils.isWindows() ? StringUtils.quote((String)str) : str;
    }

    public boolean isSkipped(String filename) {
        if (this.assembler.getSkipTemplates().contains(filename)) {
            return true;
        }
        if (this.assembler.getSkipTemplates().stream().anyMatch(filename::contains)) {
            return true;
        }
        if (this.assembler.getSkipTemplates().stream().anyMatch(filename::matches)) {
            return true;
        }
        String fname = TemplateUtils.trimTplExtension((String)filename);
        if (this.assembler.getSkipTemplates().contains(fname)) {
            return true;
        }
        if (this.assembler.getSkipTemplates().stream().anyMatch(fname::contains)) {
            return true;
        }
        return this.assembler.getSkipTemplates().stream().anyMatch(fname::matches);
    }
}

