/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.catalog.sbom;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.catalog.CatalogerSupport;
import org.jreleaser.engine.catalog.sbom.ProjectSbomCataloger;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.api.hooks.ExecutionEvent;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserSupport;
import org.jreleaser.model.internal.catalog.sbom.Sbom;
import org.jreleaser.model.internal.catalog.sbom.SbomCataloger;
import org.jreleaser.model.spi.catalog.CatalogProcessingException;
import org.jreleaser.model.spi.catalog.sbom.SbomCatalogerProcessor;

public final class SbomCatalogers {
    private SbomCatalogers() {
    }

    public static void catalog(JReleaserContext context) {
        context.getLogger().increaseIndent();
        context.getLogger().setPrefix("sbom");
        Sbom sbom = context.getModel().getCatalog().getSbom();
        if (!sbom.isEnabled()) {
            context.getLogger().info(RB.$((String)"catalogers.not.enabled", (Object[])new Object[0]));
            context.getLogger().decreaseIndent();
            context.getLogger().restorePrefix();
            return;
        }
        try {
            SbomCatalogers.doCatalog(context, sbom);
        }
        finally {
            context.getLogger().decreaseIndent();
            context.getLogger().restorePrefix();
        }
    }

    private static void doCatalog(JReleaserContext context, Sbom sbom) {
        boolean allUptodate;
        LinkedHashSet<SbomCatalogerOutcome> outcomes = new LinkedHashSet<SbomCatalogerOutcome>();
        if (!context.getIncludedCatalogers().isEmpty()) {
            for (String catalogerType : context.getIncludedCatalogers()) {
                if (!JReleaserSupport.supportedSbomCatalogers().contains(catalogerType)) {
                    context.getLogger().warn(RB.$((String)"ERROR_unsupported_cataloger", (Object[])new Object[]{catalogerType}));
                    continue;
                }
                SbomCataloger cataloger = sbom.findSbomCataloger(catalogerType);
                context.getLogger().info(RB.$((String)"catalogers.catalog.all.artifacts.with", (Object[])new Object[0]), new Object[]{catalogerType});
                outcomes.add(new SbomCatalogerOutcome(catalogerType, cataloger, SbomCatalogers.catalog(context, cataloger)));
            }
        } else {
            context.getLogger().info(RB.$((String)"catalogers.catalog.all.artifacts", (Object[])new Object[0]));
            for (SbomCataloger cataloger : sbom.findAllActiveSbomCatalogers()) {
                String catalogerType = cataloger.getType();
                if (context.getExcludedCatalogers().contains(catalogerType)) {
                    context.getLogger().info(RB.$((String)"catalogers.cataloger.excluded", (Object[])new Object[0]), new Object[]{catalogerType});
                    continue;
                }
                outcomes.add(new SbomCatalogerOutcome(catalogerType, cataloger, SbomCatalogers.catalog(context, cataloger)));
            }
        }
        Map<SbomCatalogerProcessor.Result, List<SbomCatalogerOutcome>> groupedBy = outcomes.stream().collect(Collectors.groupingBy(SbomCatalogerOutcome::getResult));
        boolean allSkipped = outcomes.size() == groupedBy.computeIfAbsent(SbomCatalogerProcessor.Result.SKIPPED, result -> Collections.emptyList()).size();
        boolean bl = allUptodate = outcomes.size() == groupedBy.computeIfAbsent(SbomCatalogerProcessor.Result.UPTODATE, result -> Collections.emptyList()).size();
        if (allSkipped) {
            context.getLogger().info(RB.$((String)"catalogers.not.triggered", (Object[])new Object[0]));
        } else if (allUptodate) {
            context.getLogger().info(RB.$((String)"catalog.sbom.not.changed", (Object[])new Object[0]));
        }
    }

    private static SbomCatalogerProcessor.Result catalog(JReleaserContext context, SbomCataloger<?> cataloger) {
        try {
            context.getLogger().increaseIndent();
            context.getLogger().setPrefix(cataloger.getType());
            CatalogerSupport.fireCatalogEvent(ExecutionEvent.before((String)JReleaserCommand.CATALOG.toStep()), context, cataloger);
            ProjectSbomCataloger projectCataloger = SbomCatalogers.createProjectCataloger(context, cataloger);
            SbomCatalogerProcessor.Result result = projectCataloger.catalog();
            CatalogerSupport.fireCatalogEvent(ExecutionEvent.success((String)JReleaserCommand.CATALOG.toStep()), context, cataloger);
            SbomCatalogerProcessor.Result result2 = result;
            return result2;
        }
        catch (CatalogProcessingException e) {
            CatalogerSupport.fireCatalogEvent(ExecutionEvent.failure((String)JReleaserCommand.CATALOG.toStep(), (Throwable)e), context, cataloger);
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
        finally {
            context.getLogger().restorePrefix();
            context.getLogger().decreaseIndent();
        }
    }

    private static ProjectSbomCataloger createProjectCataloger(JReleaserContext context, SbomCataloger<?> cataloger) {
        return ProjectSbomCataloger.builder().context(context).cataloger(cataloger).build();
    }

    private static class SbomCatalogerOutcome {
        private final String type;
        private final SbomCataloger<?> cataloger;
        private final SbomCatalogerProcessor.Result result;

        private SbomCatalogerOutcome(String type, SbomCataloger<?> cataloger, SbomCatalogerProcessor.Result result) {
            this.type = type;
            this.cataloger = cataloger;
            this.result = result;
        }

        public String getType() {
            return this.type;
        }

        public SbomCataloger<?> getCataloger() {
            return this.cataloger;
        }

        public SbomCatalogerProcessor.Result getResult() {
            return this.result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SbomCatalogerOutcome that = (SbomCatalogerOutcome)o;
            return this.type.equals(that.type);
        }

        public int hashCode() {
            return Objects.hash(this.type);
        }
    }
}

