/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.signing;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.sdk.command.Command;
import org.jreleaser.sdk.command.CommandException;
import org.jreleaser.sdk.command.CommandExecutor;
import org.jreleaser.util.StringUtils;

public final class GpgCommandSigner {
    private final JReleaserLogger logger;
    private final List<String> args = new ArrayList<String>();
    private String executable;
    private String passphrase;
    private String keyName;
    private String homeDir;
    private String publicKeyring;
    private boolean defaultKeyring;

    public GpgCommandSigner(JReleaserLogger logger) {
        this.logger = logger;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public void setHomeDir(String homeDir) {
        this.homeDir = homeDir;
    }

    public void setPublicKeyring(String publicKeyring) {
        this.publicKeyring = publicKeyring;
    }

    public void setDefaultKeyring(boolean defaultKeyring) {
        this.defaultKeyring = defaultKeyring;
    }

    public void setArgs(List<String> args) {
        this.args.clear();
        this.args.addAll(args);
    }

    public void sign(Path input, Path output) throws CommandException {
        Command cmd = this.createSignCommand();
        cmd.arg("--output").arg(output.toAbsolutePath().toString()).arg(input.toAbsolutePath().toString());
        ByteArrayInputStream stdin = StringUtils.isNotBlank((String)this.passphrase) ? new ByteArrayInputStream(this.passphrase.getBytes(StandardCharsets.UTF_8)) : new ByteArrayInputStream(new byte[0]);
        Command.Result result = new CommandExecutor(this.logger).executeCommand(cmd, (InputStream)stdin);
        if (result.getExitValue() != 0) {
            throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{result.getExitValue()}));
        }
    }

    public boolean verify(Path signature, Path target) throws CommandException {
        Command cmd = this.createVerifyCommand().arg(signature.toAbsolutePath().toString()).arg(target.toAbsolutePath().toString());
        return new CommandExecutor(this.logger, CommandExecutor.Output.QUIET).executeCommand(cmd).getExitValue() == 0;
    }

    public byte[] sign(byte[] in) throws CommandException {
        try {
            Path input = Files.createTempFile("jreleaser", "sign-input", new FileAttribute[0]);
            Files.write(input, in, StandardOpenOption.WRITE);
            Path output = Files.createTempDirectory("jreleaser-" + UUID.randomUUID(), new FileAttribute[0]).resolve(UUID.randomUUID().toString());
            this.sign(input, output);
            return Files.readAllBytes(output);
        }
        catch (IOException e) {
            throw new CommandException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private Command createSignCommand() {
        Command cmd = new Command(this.executable).args(this.args);
        if (StringUtils.isNotBlank((String)this.homeDir)) {
            cmd.arg("--homedir").arg(this.homeDir);
        }
        if (StringUtils.isNotBlank((String)this.keyName)) {
            cmd.arg("--local-user").arg(this.keyName);
        }
        cmd.arg("--armor").arg("--detach-sign").arg("--batch").arg("--no-tty");
        if (StringUtils.isNotBlank((String)this.passphrase)) {
            cmd.arg("--pinentry-mode").arg("loopback").arg("--passphrase-fd").arg("0");
        }
        if (!this.defaultKeyring) {
            cmd.arg("--no-default-keyring");
        }
        if (StringUtils.isNotBlank((String)this.publicKeyring)) {
            cmd.arg("--keyring").arg(this.publicKeyring);
        }
        return cmd;
    }

    private Command createVerifyCommand() {
        Command cmd = new Command(this.executable).args(this.args);
        if (StringUtils.isNotBlank((String)this.homeDir)) {
            cmd.arg("--homedir").arg(this.homeDir);
        }
        if (StringUtils.isNotBlank((String)this.keyName)) {
            cmd.arg("--local-user").arg(this.keyName);
        }
        if (!this.defaultKeyring) {
            cmd.arg("--no-default-keyring");
        }
        if (StringUtils.isNotBlank((String)this.publicKeyring)) {
            cmd.arg("--keyring").arg(this.publicKeyring);
        }
        cmd.arg("--verify");
        return cmd;
    }
}

