/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.common.CommitAuthor;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.packagers.AbstractRepositoryPackager;
import org.jreleaser.model.internal.packagers.PackagerRepository;
import org.jreleaser.model.internal.packagers.RepositoryTap;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Env;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class ChocolateyPackager
extends AbstractRepositoryPackager<org.jreleaser.model.api.packagers.ChocolateyPackager, ChocolateyPackager> {
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private final ChocolateyRepository repository = new ChocolateyRepository();
    private String packageName;
    private String packageVersion;
    private String username;
    private String apiKey;
    private String title;
    private String iconUrl;
    private String source;
    private Boolean remoteBuild;
    private final org.jreleaser.model.api.packagers.ChocolateyPackager immutable = new org.jreleaser.model.api.packagers.ChocolateyPackager(){

        public String getPackageName() {
            return ChocolateyPackager.this.packageName;
        }

        public String getPackageVersion() {
            return ChocolateyPackager.this.packageVersion;
        }

        public String getUsername() {
            return ChocolateyPackager.this.username;
        }

        public String getApiKey() {
            return ChocolateyPackager.this.apiKey;
        }

        public String getTitle() {
            return ChocolateyPackager.this.title;
        }

        public String getIconUrl() {
            return ChocolateyPackager.this.iconUrl;
        }

        public String getSource() {
            return ChocolateyPackager.this.source;
        }

        public boolean isRemoteBuild() {
            return ChocolateyPackager.this.isRemoteBuild();
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getBucket() {
            return ChocolateyPackager.this.repository.asImmutable();
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getPackagerRepository() {
            return this.getBucket();
        }

        public CommitAuthor getCommitAuthor() {
            return ChocolateyPackager.this.commitAuthor.asImmutable();
        }

        public String getTemplateDirectory() {
            return ChocolateyPackager.this.templateDirectory;
        }

        public List<String> getSkipTemplates() {
            return Collections.unmodifiableList(ChocolateyPackager.this.skipTemplates);
        }

        public String getType() {
            return ChocolateyPackager.this.type;
        }

        public String getDownloadUrl() {
            return ChocolateyPackager.this.downloadUrl;
        }

        public boolean supportsPlatform(String platform) {
            return ChocolateyPackager.this.supportsPlatform(platform);
        }

        public boolean supportsDistribution(Distribution.DistributionType distributionType) {
            return ChocolateyPackager.this.supportsDistribution(distributionType);
        }

        public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
            return ChocolateyPackager.this.getSupportedFileExtensions(distributionType);
        }

        public Set<Stereotype> getSupportedStereotypes() {
            return ChocolateyPackager.this.getSupportedStereotypes();
        }

        public boolean isSnapshotSupported() {
            return ChocolateyPackager.this.isSnapshotSupported();
        }

        public boolean isContinueOnError() {
            return ChocolateyPackager.this.isContinueOnError();
        }

        public Active getActive() {
            return ChocolateyPackager.this.active;
        }

        public boolean isEnabled() {
            return ChocolateyPackager.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(ChocolateyPackager.this.asMap(full));
        }

        public String getPrefix() {
            return ChocolateyPackager.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(ChocolateyPackager.this.extraProperties);
        }
    };

    public ChocolateyPackager() {
        super("chocolatey");
    }

    @Override
    public org.jreleaser.model.api.packagers.ChocolateyPackager asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(ChocolateyPackager source) {
        super.merge(source);
        this.packageName = this.merge(this.packageName, source.packageName);
        this.packageVersion = this.merge(this.packageVersion, source.packageVersion);
        this.username = this.merge(this.username, source.username);
        this.apiKey = this.merge(this.apiKey, source.apiKey);
        this.title = this.merge(this.title, source.title);
        this.iconUrl = this.merge(this.iconUrl, source.iconUrl);
        this.source = this.merge(this.source, source.source);
        this.remoteBuild = this.merge(this.remoteBuild, source.remoteBuild);
        this.setBucket(source.repository);
    }

    public String getResolvedApiKey() {
        return Env.env((String)"CHOCOLATEY_API_KEY", (String)this.apiKey);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean isRemoteBuild() {
        return this.remoteBuild != null && this.remoteBuild != false;
    }

    public void setRemoteBuild(Boolean remoteBuild) {
        this.remoteBuild = remoteBuild;
    }

    public boolean isRemoteBuildSet() {
        return this.remoteBuild != null;
    }

    public ChocolateyRepository getBucket() {
        return this.repository;
    }

    public void setBucket(ChocolateyRepository repository) {
        this.repository.merge(repository);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("packageName", this.packageName);
        props.put("packageVersion", this.packageVersion);
        props.put("username", this.username);
        props.put("apiKey", StringUtils.isNotBlank((String)this.getResolvedApiKey()) ? "************" : "**unset**");
        props.put("remoteBuild", this.isRemoteBuild());
        props.put("title", this.title);
        props.put("iconUrl", this.iconUrl);
        props.put("source", this.source);
        props.put("bucket", this.repository.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.getPackagerRepository();
    }

    public PackagerRepository getPackagerRepository() {
        return this.repository;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isWindows((String)platform) && PlatformUtils.isIntel((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution.DistributionType distributionType) {
        return SUPPORTED.containsKey(distributionType);
    }

    @Override
    public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault(distributionType, Collections.emptySet()));
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get("skipChocolatey"));
    }

    static {
        Set extensions = CollectionUtils.setOf((Object[])new String[]{FileType.ZIP.extension()});
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_PACKAGE, CollectionUtils.setOf((Object[])new String[]{FileType.EXE.extension(), FileType.MSI.extension()}));
    }

    public static final class ChocolateyRepository
    extends PackagerRepository {
        public ChocolateyRepository() {
            super("chocolatey", "chocolatey-bucket");
        }
    }
}

