/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.upload;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.upload.AbstractUploader;
import org.jreleaser.model.internal.upload.WebUploader;
import org.jreleaser.mustache.Templates;

public abstract class AbstractWebUploader<A extends org.jreleaser.model.api.upload.WebUploader, S extends AbstractWebUploader<A, S>>
extends AbstractUploader<A, S>
implements WebUploader<A> {
    protected String uploadUrl;
    protected String downloadUrl;

    protected AbstractWebUploader(String type) {
        super(type);
    }

    @Override
    public void merge(S source) {
        super.merge(source);
        this.uploadUrl = this.merge(this.uploadUrl, ((AbstractWebUploader)source).uploadUrl);
        this.downloadUrl = this.merge(this.downloadUrl, ((AbstractWebUploader)source).downloadUrl);
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, Artifact artifact) {
        return this.getResolvedDownloadUrl(context.fullProps(), artifact);
    }

    @Override
    public String getResolvedDownloadUrl(Map<String, Object> props, Artifact artifact) {
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>(this.artifactProps(props, artifact));
        p.putAll(this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.downloadUrl, p);
    }

    @Override
    public String getResolvedUploadUrl(JReleaserContext context, Artifact artifact) {
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>(this.artifactProps(context, artifact));
        p.putAll(this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.uploadUrl, p);
    }

    @Override
    public String getUploadUrl() {
        return this.uploadUrl;
    }

    @Override
    public void setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
    }

    @Override
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    @Override
    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("uploadUrl", this.uploadUrl);
        props.put("downloadUrl", this.downloadUrl);
    }
}

