/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Archive;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.JlinkAssembler;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class JlinkAssemblerResolver
extends Validator {
    public static void resolveJlinkOutputs(JReleaserContext context, Errors errors) {
        List<JlinkAssembler> activeJlinks = context.getModel().getAssemble().getActiveJlinks();
        if (!activeJlinks.isEmpty()) {
            context.getLogger().debug("assemble.jlink");
        }
        for (JlinkAssembler jlink : activeJlinks) {
            if (!jlink.isExported()) continue;
            JlinkAssemblerResolver.resolveJlinkOutputs(context, jlink, errors);
        }
    }

    private static void resolveJlinkOutputs(JReleaserContext context, JlinkAssembler jlink, Errors errors) {
        Path baseOutputDirectory = context.getAssembleDirectory().resolve(jlink.getName()).resolve(jlink.getType());
        String imageName = jlink.getResolvedImageName(context);
        if (StringUtils.isNotBlank((String)jlink.getImageNameTransform())) {
            imageName = jlink.getResolvedImageNameTransform(context);
        }
        for (Artifact targetJdk : jlink.getTargetJdks()) {
            if (!context.isPlatformSelected(targetJdk)) continue;
            String platform = targetJdk.getPlatform();
            String platformReplaced = jlink.getPlatform().applyReplacements(platform);
            String str = targetJdk.getExtraProperties().getOrDefault("archiveFormat", "ZIP").toString();
            Archive.Format archiveFormat = Archive.Format.of((String)str);
            Path image = baseOutputDirectory.resolve(imageName + "-" + platformReplaced + "." + archiveFormat.extension()).toAbsolutePath();
            if (!Files.exists(image, new LinkOption[0])) {
                errors.assembly(RB.$((String)"validation_missing_assembly", (Object[])new Object[]{jlink.getType(), jlink.getName(), jlink.getName()}));
                continue;
            }
            Artifact artifact = Artifact.of(image, platform);
            artifact.setExtraProperties(jlink.getExtraProperties());
            artifact.activate();
            jlink.addOutput(artifact);
        }
    }
}

