/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.JlinkAssembler;
import org.jreleaser.model.internal.assemble.JpackageAssembler;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.validation.common.TemplateValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.SemanticVersion;

public abstract class JpackageAssemblerValidator
extends Validator {
    private static final String MAC_IDENTIFIER = "[a-zA-Z0-9][a-zA-Z0-9\\.\\-]*";
    private static final Pattern MAC_IDENTIFIER_PATTERN = Pattern.compile("[a-zA-Z0-9][a-zA-Z0-9\\.\\-]*");

    public static void validateJpackage(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, JpackageAssembler> jpackage = context.getModel().getAssemble().getJpackage();
        if (!jpackage.isEmpty()) {
            context.getLogger().debug("assemble.jpackage");
        }
        for (Map.Entry<String, JpackageAssembler> e : jpackage.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig() && !mode.validateAssembly()) continue;
            JpackageAssemblerValidator.validateJpackage(context, mode, e.getValue(), errors);
        }
    }

    public static void postValidateJpackage(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("assemble.jpackage");
        Map<String, JpackageAssembler> jpackage = context.getModel().getAssemble().getJpackage();
        for (Map.Entry<String, JpackageAssembler> e : jpackage.entrySet()) {
            JpackageAssemblerValidator.postValidateJpackage(context, mode, e.getValue(), errors);
        }
    }

    private static void validateJpackage(JReleaserContext context, JReleaserContext.Mode mode, JpackageAssembler jpackage, Errors errors) {
        Project project;
        context.getLogger().debug("assemble.jpackage.{}", new Object[]{jpackage.getName()});
        if (!jpackage.isActiveSet()) {
            jpackage.setActive(Active.NEVER);
        }
        if (!jpackage.resolveEnabled(project = context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (null == jpackage.getStereotype()) {
            jpackage.setStereotype(context.getModel().getProject().getStereotype());
        }
        JpackageAssembler.PlatformPackager packager = jpackage.getResolvedPlatformPackager();
        JpackageAssembler.ApplicationPackage applicationPackage = jpackage.getApplicationPackage();
        packager.enable();
        if (StringUtils.isNotBlank((String)jpackage.getJlink())) {
            JlinkAssembler jlink = context.getModel().getAssemble().findJlink(jpackage.getJlink());
            Path baseOutputDirectory = context.getAssembleDirectory().resolve(jlink.getName()).resolve(jlink.getType());
            String imageName = jlink.getResolvedImageName(context);
            ArrayList<Artifact> candidateRuntimeImages = new ArrayList<Artifact>();
            for (Artifact targetJdk : jlink.getTargetJdks()) {
                if (!context.isPlatformSelected(targetJdk)) continue;
                String platform = targetJdk.getPlatform();
                Path path = baseOutputDirectory.resolve("work-" + platform).resolve(imageName + "-" + platform).toAbsolutePath();
                candidateRuntimeImages.add(Artifact.of(path, platform));
            }
            if (jpackage.getRuntimeImages().size() > 0 && jpackage.getRuntimeImages().size() != candidateRuntimeImages.size()) {
                errors.configuration(RB.$((String)"validation_jpackage_jlink_application", (Object[])new Object[]{jpackage.getName()}));
            }
            int count = 0;
            for (Artifact runtimeImage : jpackage.getRuntimeImages()) {
                Path path;
                Path rp = runtimeImage.getResolvedPath(context, jpackage);
                Path tp = runtimeImage.getResolvedTransform(context, jpackage);
                Path path2 = path = tp != null ? tp : rp;
                if (!candidateRuntimeImages.stream().anyMatch(a -> a.getPath().equals(path.toString()))) continue;
                ++count;
            }
            if (jpackage.getRuntimeImages().size() > 0 && count != candidateRuntimeImages.size()) {
                errors.configuration(RB.$((String)"validation_jpackage_jlink_application", (Object[])new Object[]{jpackage.getName()}));
            }
            jpackage.setJava(jlink.getJava());
            jpackage.setMainJar(jlink.getMainJar());
            jpackage.setJars(jlink.getJars());
            packager.setJdk(jlink.getJdk());
            if (StringUtils.isBlank((String)jpackage.getExecutable())) {
                jpackage.setExecutable(jlink.getExecutable());
            }
            for (Artifact runtimeImage : candidateRuntimeImages) {
                runtimeImage.activate();
                jpackage.addRuntimeImage(runtimeImage);
            }
        }
        context.getLogger().debug("assemble.jpackage.{}.java", new Object[]{jpackage.getName()});
        if (!JpackageAssemblerValidator.validateJava(context, jpackage, errors)) {
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            jpackage.disable();
            return;
        }
        if (StringUtils.isBlank((String)jpackage.getExecutable())) {
            jpackage.setExecutable(jpackage.getName());
        }
        if (jpackage.getRuntimeImages().size() == 0) {
            errors.configuration(RB.$((String)"validation_jpackage_runtime_images_missing", (Object[])new Object[]{jpackage.getName()}));
            return;
        }
        int i = 0;
        for (Artifact runtimeImage : jpackage.getRuntimeImages()) {
            JpackageAssemblerValidator.validateRuntimeImage(context, mode, jpackage, runtimeImage, i++, errors);
        }
        Map<String, List<Artifact>> byPlatform = jpackage.getRuntimeImages().stream().collect(Collectors.groupingBy(ri -> StringUtils.isBlank((String)ri.getPlatform()) ? "<nil>" : ri.getPlatform()));
        if (byPlatform.containsKey("<nil>")) {
            errors.configuration(RB.$((String)"validation_jpackage_runtime_image_platform", (Object[])new Object[]{jpackage.getName()}));
        }
        byPlatform.forEach((p, jdks) -> {
            if (jdks.size() > 1) {
                errors.configuration(RB.$((String)"validation_jpackage_runtime_image_multiple_platforms", (Object[])new Object[]{jpackage.getName(), p}));
            }
        });
        if (StringUtils.isBlank((String)packager.getJdk().getPath())) {
            String javaHome = System.getProperty("java.home");
            if (StringUtils.isBlank((String)javaHome)) {
                errors.configuration(RB.$((String)"validation_java_home_missing", (Object[])new Object[0]));
                return;
            }
            packager.getJdk().setPath(javaHome);
            packager.getJdk().setPlatform(PlatformUtils.getCurrentFull());
        }
        if (packager.getTypes().isEmpty()) {
            packager.setTypes(Collections.singletonList(packager.getValidTypes().get(0)));
        }
        if (StringUtils.isBlank((String)applicationPackage.getAppName())) {
            applicationPackage.setAppName(jpackage.getName());
        }
        if (StringUtils.isBlank((String)applicationPackage.getAppVersion())) {
            applicationPackage.setAppVersion(project.getResolvedVersion());
        }
        String appVersion = applicationPackage.getResolvedAppVersion(context, jpackage);
        try {
            SemanticVersion v = SemanticVersion.of((String)appVersion);
            if (StringUtils.isNotBlank((String)v.getBuild()) || StringUtils.isNotBlank((String)v.getTag())) {
                errors.configuration(RB.$((String)"validation_jpackage_invalid_appversion_t", (Object[])new Object[]{appVersion}));
            }
            if (PlatformUtils.isMac() && v.getMajor() <= 0) {
                errors.configuration(RB.$((String)"validation_jpackage_invalid_appversion_n", (Object[])new Object[]{appVersion}));
            }
        }
        catch (IllegalArgumentException e) {
            errors.configuration(RB.$((String)"validation_jpackage_invalid_appversion_n", (Object[])new Object[]{appVersion}));
        }
        if (StringUtils.isBlank((String)applicationPackage.getVendor())) {
            applicationPackage.setVendor(project.getVendor());
        }
        if (StringUtils.isBlank((String)applicationPackage.getVendor())) {
            errors.configuration(RB.$((String)"validation_jpackage_missing_vendor", (Object[])new Object[]{jpackage.getName()}));
        }
        if (StringUtils.isBlank((String)applicationPackage.getCopyright())) {
            applicationPackage.setCopyright(project.getCopyright());
        }
        if (mode == JReleaserContext.Mode.ASSEMBLE) {
            TemplateValidator.validateTemplate(context, jpackage, errors);
        }
        if (StringUtils.isBlank((String)packager.getAppName())) {
            packager.setAppName(jpackage.getApplicationPackage().getAppName());
        }
        if (packager instanceof JpackageAssembler.Linux) {
            JpackageAssemblerValidator.validateLinux(context, jpackage, (JpackageAssembler.Linux)packager, errors);
        }
        if (packager instanceof JpackageAssembler.Osx) {
            JpackageAssemblerValidator.validateOsx(context, jpackage, (JpackageAssembler.Osx)packager, errors);
        }
        if (packager instanceof JpackageAssembler.Windows) {
            JpackageAssemblerValidator.validateWindows(context, jpackage, (JpackageAssembler.Windows)packager, errors);
        }
    }

    private static void validateOsx(JReleaserContext context, JpackageAssembler jpackage, JpackageAssembler.Osx packager, Errors errors) {
        if (StringUtils.isNotBlank((String)packager.getPackageIdentifier()) && !MAC_IDENTIFIER_PATTERN.matcher(packager.getPackageIdentifier()).matches()) {
            errors.configuration(RB.$((String)"validation_jpackage_invalid_mac_package_identifier", (Object[])new Object[]{packager.getPackageIdentifier(), MAC_IDENTIFIER}));
        }
        if (StringUtils.isBlank((String)packager.getPackageName())) {
            packager.setPackageName(packager.getAppName());
        }
        if (StringUtils.isNotBlank((String)packager.getPackageName()) && packager.getPackageName().length() > 16) {
            errors.configuration(RB.$((String)"validation_jpackage_invalid_mac_package_name", (Object[])new Object[]{packager.getPackageName()}));
        }
    }

    private static void validateLinux(JReleaserContext context, JpackageAssembler jpackage, JpackageAssembler.Linux packager, Errors errors) {
        if (StringUtils.isBlank((String)packager.getLicense())) {
            packager.setLicense(context.getModel().getProject().getLicense());
        }
    }

    private static void validateWindows(JReleaserContext context, JpackageAssembler jpackage, JpackageAssembler.Windows packager, Errors errors) {
    }

    private static boolean validateJava(JReleaserContext context, JpackageAssembler jpackage, Errors errors) {
        Project project = context.getModel().getProject();
        if (!jpackage.getJava().isEnabledSet() && project.getJava().isEnabledSet()) {
            jpackage.getJava().setEnabled(project.getJava().isEnabled());
        }
        if (!jpackage.getJava().isEnabledSet()) {
            jpackage.getJava().setEnabled(jpackage.getJava().isSet());
        }
        if (!jpackage.getJava().isEnabled()) {
            return true;
        }
        if (StringUtils.isBlank((String)jpackage.getJava().getArtifactId())) {
            jpackage.getJava().setArtifactId(project.getJava().getArtifactId());
        }
        if (StringUtils.isBlank((String)jpackage.getJava().getGroupId())) {
            jpackage.getJava().setGroupId(project.getJava().getGroupId());
        }
        if (StringUtils.isBlank((String)jpackage.getJava().getVersion())) {
            jpackage.getJava().setVersion(project.getJava().getVersion());
        }
        if (StringUtils.isBlank((String)jpackage.getJava().getMainModule())) {
            jpackage.getJava().setMainModule(project.getJava().getMainModule());
        }
        if (StringUtils.isBlank((String)jpackage.getJava().getMainClass())) {
            jpackage.getJava().setMainClass(project.getJava().getMainClass());
        }
        if (StringUtils.isBlank((String)jpackage.getJava().getGroupId())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"jpackage." + jpackage.getName() + ".java.groupId"}));
        }
        if (StringUtils.isBlank((String)jpackage.getJava().getMainClass())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"jpackage." + jpackage.getName() + ".java.mainClass"}));
        }
        return true;
    }

    private static void validateRuntimeImage(JReleaserContext context, JReleaserContext.Mode mode, JpackageAssembler jpackage, Artifact runtimeImage, int index, Errors errors) {
        if (mode == JReleaserContext.Mode.FULL) {
            return;
        }
        if (null == runtimeImage) {
            errors.configuration(RB.$((String)"validation_is_null", (Object[])new Object[]{"jpackage." + jpackage.getName() + ".runtimeImage[" + index + "]"}));
            return;
        }
        if (StringUtils.isBlank((String)runtimeImage.getPath())) {
            errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"jpackage." + jpackage.getName() + ".runtimeImage[" + index + "].path"}));
        }
        if (StringUtils.isNotBlank((String)runtimeImage.getPlatform()) && !PlatformUtils.isSupported((String)runtimeImage.getPlatform().trim())) {
            context.getLogger().warn(RB.$((String)"validation_jpackage_platform", (Object[])new Object[]{jpackage.getName(), index, runtimeImage.getPlatform(), System.lineSeparator(), PlatformUtils.getSupportedOsNames(), System.lineSeparator(), PlatformUtils.getSupportedOsArchs()}));
        }
    }

    private static void postValidateJpackage(JReleaserContext context, JReleaserContext.Mode mode, JpackageAssembler jpackage, Errors errors) {
        Project project = context.getModel().getProject();
        if (!jpackage.resolveEnabled(project)) {
            return;
        }
        JpackageAssembler.ApplicationPackage applicationPackage = jpackage.getApplicationPackage();
        if (StringUtils.isBlank((String)applicationPackage.getCopyright())) {
            applicationPackage.setCopyright(project.getCopyright());
        }
    }
}

