/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.files;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.files.Files;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;

public abstract class FilesValidator
extends Validator {
    public static void validateFiles(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        if (!mode.validateConfig()) {
            return;
        }
        context.getLogger().debug("files");
        Files files = context.getModel().getFiles();
        if (!files.isActiveSet()) {
            files.setActive(Active.ALWAYS);
        }
        if (!files.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        files.getArtifacts().forEach(artifact -> {
            if (context.isPlatformSelected((Artifact)artifact)) {
                artifact.activate();
            }
        });
        FilesValidator.validateGlobs(context, files.getGlobs(), "files.glob", errors);
    }
}

