/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.release;

import java.util.Map;
import java.util.Optional;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.release.GitlabReleaser;
import org.jreleaser.model.internal.upload.Uploader;
import org.jreleaser.model.internal.validation.release.BaseReleaserValidator;
import org.jreleaser.util.Errors;

public abstract class GitlabReleaserValidator
extends BaseReleaserValidator {
    public static boolean validateGitlab(JReleaserContext context, JReleaserContext.Mode mode, GitlabReleaser gitlab, Errors errors) {
        if (null == gitlab) {
            return false;
        }
        context.getLogger().debug("release.gitlab");
        GitlabReleaserValidator.validateGitService(context, mode, gitlab, errors);
        gitlab.getPrerelease().disable();
        for (Map.Entry<String, String> e : gitlab.getUploadLinks().entrySet()) {
            Optional<? extends Uploader> uploader = context.getModel().getUpload().getUploader(e.getKey(), e.getValue());
            if (uploader.isPresent()) continue;
            errors.configuration(RB.$((String)"validation_gitlab_non_matching_uploader", (Object[])new Object[]{e.getKey(), e.getValue()}));
        }
        return gitlab.isEnabled();
    }
}

