/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.codeberg;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.model.api.common.Apply;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.util.VersionUtils;
import org.jreleaser.model.spi.release.AbstractReleaser;
import org.jreleaser.model.spi.release.Asset;
import org.jreleaser.model.spi.release.Release;
import org.jreleaser.model.spi.release.ReleaseException;
import org.jreleaser.model.spi.release.Repository;
import org.jreleaser.model.spi.release.User;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.git.ChangelogProvider;
import org.jreleaser.sdk.git.GitSdk;
import org.jreleaser.sdk.git.ReleaseUtils;
import org.jreleaser.sdk.gitea.Gitea;
import org.jreleaser.sdk.gitea.api.GtIssue;
import org.jreleaser.sdk.gitea.api.GtLabel;
import org.jreleaser.sdk.gitea.api.GtMilestone;
import org.jreleaser.sdk.gitea.api.GtRelease;
import org.jreleaser.sdk.gitea.api.GtRepository;
import org.jreleaser.util.StringUtils;

public class CodebergReleaser
extends AbstractReleaser<org.jreleaser.model.api.release.CodebergReleaser> {
    private final org.jreleaser.model.internal.release.CodebergReleaser codeberg;

    public CodebergReleaser(JReleaserContext context, List<Asset> assets) {
        super(context, assets);
        this.codeberg = context.getModel().getRelease().getCodeberg();
    }

    public org.jreleaser.model.api.release.CodebergReleaser getReleaser() {
        return this.codeberg.asImmutable();
    }

    public String generateReleaseNotes() throws IOException {
        try {
            return ChangelogProvider.getChangelog((JReleaserContext)this.context).trim();
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_changelog", (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void createTag() throws ReleaseException {
        ReleaseUtils.createTag((JReleaserContext)this.context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createRelease() throws ReleaseException {
        this.context.getLogger().info(RB.$((String)"git.releaser.releasing", (Object[])new Object[0]), new Object[]{this.codeberg.getResolvedRepoUrl(this.context.getModel())});
        String tagName = this.codeberg.getEffectiveTagName(this.context.getModel());
        try {
            Gitea api = new Gitea(this.context.getLogger(), this.codeberg.getApiEndpoint(), this.codeberg.getResolvedToken(), this.codeberg.getConnectTimeout().intValue(), this.codeberg.getReadTimeout().intValue());
            String branch = this.codeberg.getBranch();
            List branchNames = api.listBranches(this.codeberg.getOwner(), this.codeberg.getName());
            if (!branchNames.contains(branch)) {
                throw new ReleaseException(RB.$((String)"ERROR_git_release_branch_not_exists", (Object[])new Object[]{branch, branchNames}));
            }
            String changelog = this.context.getChangelog();
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.lookup", (Object[])new Object[0]), new Object[]{tagName, this.codeberg.getCanonicalRepoName()});
            GtRelease release = api.findReleaseByTag(this.codeberg.getOwner(), this.codeberg.getName(), tagName);
            boolean snapshot = this.context.getModel().getProject().isSnapshot();
            if (null != release) {
                this.context.getLogger().debug(RB.$((String)"git.releaser.release.exists", (Object[])new Object[0]), new Object[]{tagName});
                if (this.codeberg.isOverwrite() || snapshot) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.delete", (Object[])new Object[0]), new Object[]{tagName});
                    if (!this.context.isDryrun()) {
                        api.deleteRelease(this.codeberg.getOwner(), this.codeberg.getName(), tagName, release.getId());
                    }
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
                    this.createRelease(api, tagName, changelog, this.codeberg.isMatch());
                    return;
                }
                if (this.codeberg.getUpdate().isEnabled()) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.update", (Object[])new Object[0]), new Object[]{tagName});
                    if (this.context.isDryrun()) return;
                    GtRelease updater = new GtRelease();
                    updater.setPrerelease(Boolean.valueOf(this.codeberg.getPrerelease().isEnabled()));
                    updater.setDraft(Boolean.valueOf(this.codeberg.isDraft()));
                    if (this.codeberg.getUpdate().getSections().contains(UpdateSection.TITLE)) {
                        this.context.getLogger().info(RB.$((String)"git.releaser.release.update.title", (Object[])new Object[0]), new Object[]{this.codeberg.getEffectiveReleaseName()});
                        updater.setName(this.codeberg.getEffectiveReleaseName());
                    }
                    if (this.codeberg.getUpdate().getSections().contains(UpdateSection.BODY)) {
                        this.context.getLogger().info(RB.$((String)"git.releaser.release.update.body", (Object[])new Object[0]));
                        updater.setBody(changelog);
                    }
                    api.updateRelease(this.codeberg.getOwner(), this.codeberg.getName(), release.getId(), updater);
                    if (this.codeberg.getUpdate().getSections().contains(UpdateSection.ASSETS)) {
                        this.updateAssets(api, release);
                    }
                    this.updateIssues(this.codeberg, api);
                    return;
                }
                if (this.context.isDryrun()) {
                    this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
                    this.createRelease(api, tagName, changelog, false);
                    return;
                }
                throw new IllegalStateException(RB.$((String)"ERROR_git_releaser_cannot_release", (Object[])new Object[]{StringUtils.capitalize((String)this.codeberg.getServiceName()), tagName}));
            }
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.not.found", (Object[])new Object[0]), new Object[]{tagName});
            this.context.getLogger().debug(RB.$((String)"git.releaser.release.create", (Object[])new Object[0]), new Object[]{tagName});
            this.createRelease(api, tagName, changelog, snapshot && this.codeberg.isMatch());
            return;
        }
        catch (RestAPIException e) {
            this.context.getLogger().trace(e.getStatus() + " " + e.getReason());
            this.context.getLogger().trace((Throwable)e);
            throw new ReleaseException((Throwable)e);
        }
        catch (IOException | IllegalStateException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new ReleaseException((Throwable)e);
        }
    }

    protected Repository.Kind resolveRepositoryKind() {
        return Repository.Kind.OTHER;
    }

    public Repository maybeCreateRepository(String owner, String repo, String password) throws IOException {
        this.context.getLogger().debug(RB.$((String)"git.repository.lookup", (Object[])new Object[0]), new Object[]{owner, repo});
        Gitea api = new Gitea(this.context.getLogger(), this.codeberg.getApiEndpoint(), password, this.codeberg.getConnectTimeout().intValue(), this.codeberg.getReadTimeout().intValue());
        GtRepository repository = api.findRepository(owner, repo);
        if (null == repository) {
            repository = api.createRepository(owner, repo);
        }
        return new Repository(this.resolveRepositoryKind(), owner, repo, repository.getHtmlUrl(), repository.getCloneUrl());
    }

    public Optional<User> findUser(String email, String name) {
        try {
            String host = this.codeberg.getHost();
            String endpoint = this.codeberg.getApiEndpoint();
            host = endpoint.startsWith("https") ? "https://" + host : "http://" + host;
            if (!host.endsWith("/")) {
                host = host + "/";
            }
            return new Gitea(this.context.getLogger(), this.codeberg.getApiEndpoint(), this.codeberg.getResolvedToken(), this.codeberg.getConnectTimeout().intValue(), this.codeberg.getReadTimeout().intValue()).findUser(email, name, host);
        }
        catch (IOException | RestAPIException e) {
            this.context.getLogger().trace(e);
            this.context.getLogger().debug(RB.$((String)"git.releaser.user.not.found", (Object[])new Object[0]), new Object[]{email});
            return Optional.empty();
        }
    }

    public List<Release> listReleases(String owner, String repo) throws IOException {
        Gitea api = new Gitea(this.context.getLogger(), this.codeberg.getApiEndpoint(), this.codeberg.getResolvedToken(), this.codeberg.getConnectTimeout().intValue(), this.codeberg.getReadTimeout().intValue());
        List releases = api.listReleases(owner, repo);
        VersionUtils.clearUnparseableTags();
        Pattern versionPattern = VersionUtils.resolveVersionPattern((JReleaserContext)this.context);
        for (Release release : releases) {
            release.setVersion(VersionUtils.version((JReleaserContext)this.context, (String)release.getTagName(), (Pattern)versionPattern));
        }
        releases.sort((r1, r2) -> r2.getVersion().compareTo((Object)r1.getVersion()));
        return releases;
    }

    private void createRelease(Gitea api, String tagName, String changelog, boolean deleteTags) throws IOException {
        Optional milestone;
        if (this.context.isDryrun()) {
            for (Asset asset : this.assets) {
                if (0L == Files.size(asset.getPath()) || !Files.exists(asset.getPath(), new LinkOption[0])) continue;
                this.context.getLogger().info(" " + RB.$((String)"git.upload.asset", (Object[])new Object[0]), new Object[]{asset.getFilename()});
            }
            this.updateIssues(this.codeberg, api);
            return;
        }
        if (deleteTags) {
            this.deleteTags(api, this.codeberg.getOwner(), this.codeberg.getName(), tagName);
        }
        if (deleteTags || !this.codeberg.isSkipTag()) {
            this.context.getLogger().debug(RB.$((String)"git.releaser.repository.tag", (Object[])new Object[0]), new Object[]{tagName});
            GitSdk.of((JReleaserContext)this.context).tag(tagName, true, this.context);
        }
        GtRelease release = new GtRelease();
        release.setName(this.codeberg.getEffectiveReleaseName());
        release.setTagName(tagName);
        release.setTargetCommitish(this.codeberg.getBranch());
        release.setBody(changelog);
        release = api.createRelease(this.codeberg.getOwner(), this.codeberg.getName(), release);
        api.uploadAssets(this.codeberg.getOwner(), this.codeberg.getName(), release, this.assets);
        if (this.codeberg.getMilestone().isClose() && !this.context.getModel().getProject().isSnapshot() && (milestone = api.findMilestoneByName(this.codeberg.getOwner(), this.codeberg.getName(), this.codeberg.getMilestone().getEffectiveName())).isPresent()) {
            api.closeMilestone(this.codeberg.getOwner(), this.codeberg.getName(), (GtMilestone)milestone.get());
        }
        this.updateIssues(this.codeberg, api);
    }

    private void updateIssues(org.jreleaser.model.internal.release.CodebergReleaser codeberg, Gitea api) throws IOException {
        if (!codeberg.getIssues().isEnabled()) {
            return;
        }
        List issueNumbers = ChangelogProvider.getIssues((JReleaserContext)this.context);
        if (!issueNumbers.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"git.issue.release.mark", (Object[])new Object[]{issueNumbers.size()}));
        }
        if (this.context.isDryrun()) {
            for (String issueNumber : issueNumbers) {
                this.context.getLogger().debug(RB.$((String)"git.issue.release", (Object[])new Object[]{issueNumber}));
            }
            return;
        }
        String tagName = codeberg.getEffectiveTagName(this.context.getModel());
        String labelName = codeberg.getIssues().getLabel().getName();
        String labelColor = codeberg.getIssues().getLabel().getColor();
        Map props = codeberg.props(this.context.getModel());
        codeberg.fillProps(props, this.context.getModel());
        String comment = Templates.resolveTemplate((String)codeberg.getIssues().getComment(), (Map)props);
        if (labelColor.startsWith("#")) {
            labelColor = labelColor.substring(1);
        }
        GtLabel gtLabel = null;
        try {
            gtLabel = api.getOrCreateLabel(codeberg.getOwner(), codeberg.getName(), labelName, labelColor, codeberg.getIssues().getLabel().getDescription());
        }
        catch (IOException e) {
            throw new IllegalStateException(RB.$((String)"ERROR_git_releaser_fetch_label", (Object[])new Object[]{tagName, labelName}), e);
        }
        Optional milestone = Optional.empty();
        Apply applyMilestone = codeberg.getIssues().getApplyMilestone();
        if (codeberg.getMilestone().isClose() && !this.context.getModel().getProject().isSnapshot() && !(milestone = api.findMilestoneByName(codeberg.getOwner(), codeberg.getName(), codeberg.getMilestone().getEffectiveName())).isPresent()) {
            milestone = api.findClosedMilestoneByName(codeberg.getOwner(), codeberg.getName(), codeberg.getMilestone().getEffectiveName());
        }
        for (String issueNumber : issueNumbers) {
            GtIssue gtIssue;
            Optional op = api.findIssue(codeberg.getOwner(), codeberg.getName(), Integer.parseInt(issueNumber));
            if (!op.isPresent() || !(gtIssue = (GtIssue)op.get()).getState().equals("closed") || !gtIssue.getLabels().stream().noneMatch(l -> l.getName().equals(labelName))) continue;
            this.context.getLogger().debug(RB.$((String)"git.issue.release", (Object[])new Object[]{issueNumber}));
            api.addLabelToIssue(codeberg.getOwner(), codeberg.getName(), gtIssue, gtLabel);
            api.commentOnIssue(codeberg.getOwner(), codeberg.getName(), gtIssue, comment);
            milestone.ifPresent(gtMilestone -> this.applyMilestone(codeberg, api, issueNumber, gtIssue, applyMilestone, (GtMilestone)gtMilestone));
        }
    }

    private void applyMilestone(org.jreleaser.model.internal.release.CodebergReleaser codeberg, Gitea api, String issueNumber, GtIssue gtIssue, Apply applyMilestone, GtMilestone targetMilestone) {
        GtMilestone issueMilestone = gtIssue.getMilestone();
        String targetMilestoneTitle = targetMilestone.getTitle();
        if (null == issueMilestone) {
            this.context.getLogger().debug(RB.$((String)"git.issue.milestone.apply", (Object[])new Object[]{targetMilestoneTitle, issueNumber}));
            api.setMilestoneOnIssue(codeberg.getOwner(), codeberg.getName(), gtIssue, targetMilestone);
        } else {
            String milestoneTitle = issueMilestone.getTitle();
            if (applyMilestone == Apply.ALWAYS) {
                this.context.getLogger().debug(StringUtils.uncapitalize((String)RB.$((String)"git.issue.milestone.warn", (Object[])new Object[]{issueNumber, milestoneTitle})));
            } else if (applyMilestone == Apply.WARN) {
                if (!milestoneTitle.equals(targetMilestoneTitle)) {
                    this.context.getLogger().warn(RB.$((String)"git.issue.milestone.warn", (Object[])new Object[]{issueNumber, milestoneTitle}));
                }
            } else if (applyMilestone == Apply.FORCE) {
                if (!milestoneTitle.equals(targetMilestoneTitle)) {
                    this.context.getLogger().warn(RB.$((String)"git.issue.milestone.force", (Object[])new Object[]{targetMilestoneTitle, issueNumber, milestoneTitle}));
                    api.setMilestoneOnIssue(codeberg.getOwner(), codeberg.getName(), gtIssue, targetMilestone);
                } else {
                    this.context.getLogger().debug(StringUtils.uncapitalize((String)RB.$((String)"git.issue.milestone.warn", (Object[])new Object[]{issueNumber, milestoneTitle})));
                }
            }
        }
    }

    private void updateAssets(Gitea api, GtRelease release) throws IOException {
        ArrayList assetsToBeUpdated = new ArrayList();
        ArrayList assetsToBeUploaded = new ArrayList();
        Map existingAssets = api.listAssets(this.codeberg.getOwner(), this.codeberg.getName(), release);
        LinkedHashMap assetsToBePublished = new LinkedHashMap();
        this.assets.forEach(asset -> assetsToBePublished.put(asset.getFilename(), asset));
        assetsToBePublished.keySet().forEach(name -> {
            if (existingAssets.containsKey(name)) {
                assetsToBeUpdated.add((Asset)assetsToBePublished.get(name));
            } else {
                assetsToBeUploaded.add((Asset)assetsToBePublished.get(name));
            }
        });
        api.updateAssets(this.codeberg.getOwner(), this.codeberg.getName(), release, assetsToBeUpdated, existingAssets);
        api.uploadAssets(this.codeberg.getOwner(), this.codeberg.getName(), release, assetsToBeUploaded);
    }

    private void deleteTags(Gitea api, String owner, String repo, String tagName) {
        try {
            api.deleteTag(owner, repo, tagName);
        }
        catch (RestAPIException restAPIException) {
            // empty catch block
        }
    }
}

