/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.googlechat;

import java.util.LinkedHashMap;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.googlechat.Message;
import org.jreleaser.util.StringUtils;

public class GoogleChatAnnouncer
implements Announcer<org.jreleaser.model.api.announce.GoogleChatAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.GoogleChatAnnouncer googleChat;

    GoogleChatAnnouncer(JReleaserContext context) {
        this.context = context;
        this.googleChat = context.getModel().getAnnounce().getGoogleChat();
    }

    public org.jreleaser.model.api.announce.GoogleChatAnnouncer getAnnouncer() {
        return this.googleChat.asImmutable();
    }

    public String getName() {
        return "googlechat";
    }

    public boolean isEnabled() {
        return this.googleChat.isEnabled();
    }

    public void announce() throws AnnounceException {
        String message;
        if (StringUtils.isNotBlank((String)this.googleChat.getMessage())) {
            message = this.googleChat.getResolvedMessage(this.context);
        } else {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            props.put("changelog", MustacheUtils.passThrough((String)this.context.getChangelog()));
            this.context.getModel().getRelease().getReleaser().fillProps(props, this.context.getModel());
            message = this.googleChat.getResolvedMessageTemplate(this.context, props);
        }
        this.context.getLogger().info("message: {}", new Object[]{message});
        if (!this.context.isDryrun()) {
            ClientUtils.webhook((JReleaserLogger)this.context.getLogger(), (String)this.googleChat.getResolvedWebhook(), (int)this.googleChat.getConnectTimeout(), (int)this.googleChat.getReadTimeout(), (Object)Message.of(message));
        }
    }
}

