/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.version;

import java.time.YearMonth;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jreleaser.bundle.RB;
import org.jreleaser.util.ObjectUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.Version;

public class ChronVer
implements Version<ChronVer> {
    private static final Pattern PATTERN = Pattern.compile("^([2-9][0-9]{3})\\.(0[1-9]|1[0-2])\\.(0[1-9]|[1-2][0-9]|3[0-1])(?:\\.((?:[1-9]\\d*)(?:(?:-[a-zA-Z0-9]+)+(?:\\.[1-9]\\d*)?)?))?$");
    private static final Pattern CHANGESET = Pattern.compile("^(?:((?:[1-9]\\d*))(?:-([a-zA-Z0-9-]+[a-zA-Z0-9]?)(?:\\.([1-9]\\d*))?)?)?$");
    private final int year;
    private final int month;
    private final int day;
    private final Changeset changeset;

    private ChronVer(int year, int month, int day, Changeset changeset) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.changeset = changeset;
    }

    public boolean hasChangeset() {
        return !this.changeset.isEmpty();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public Changeset getChangeset() {
        return this.changeset;
    }

    @Override
    public String toRpmVersion() {
        return this.toString().replace("-", "_");
    }

    @Override
    public boolean equalsSpec(ChronVer version) {
        return true;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.year).append(".").append(this.month).append(".").append(this.day);
        if (this.hasChangeset()) {
            b.append(".").append(this.changeset);
        }
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChronVer version = (ChronVer)o;
        return this.year == version.year && this.month == version.month && this.day == version.day && Objects.equals(this.changeset, version.changeset);
    }

    public int hashCode() {
        return Objects.hash(this.year, this.month, this.day, this.changeset);
    }

    @Override
    public int compareTo(ChronVer other) {
        int result = this.year - other.year;
        if (result == 0 && (result = this.month - other.month) == 0) {
            result = this.day - other.day;
        }
        if (result == 0) {
            result = this.changeset.compareTo(other.changeset);
        }
        return result;
    }

    public static ChronVer defaultOf() {
        return ChronVer.of("2000.01.01");
    }

    public static ChronVer of(String version) {
        StringUtils.requireNonBlank((String)version, (String)"Argument 'version' must not be blank");
        Matcher m = PATTERN.matcher(version.trim());
        if (m.matches()) {
            int year = Integer.parseInt(m.group(1));
            String s = m.group(2);
            int month = Integer.parseInt(s.startsWith("0") ? s.substring(1) : s);
            s = m.group(3);
            int day = Integer.parseInt(s.startsWith("0") ? s.substring(1) : s);
            String changeset = m.group(4);
            if (day > YearMonth.of(year, month).lengthOfMonth()) {
                throw new IllegalArgumentException(RB.$((String)"ERROR_version_parse", (Object[])new Object[]{version}));
            }
            return ChronVer.of(year, month, day, changeset);
        }
        throw new IllegalArgumentException(RB.$((String)"ERROR_version_parse", (Object[])new Object[]{version}));
    }

    public static ChronVer of(int year, int month, int day, String changeset) {
        ObjectUtils.requireState((year > -1 ? 1 : 0) != 0, (String)"Argument 'year' must not be negative");
        ObjectUtils.requireState((month > -1 ? 1 : 0) != 0, (String)"Argument 'month' must not be negative");
        ObjectUtils.requireState((day > -1 ? 1 : 0) != 0, (String)"Argument 'day' must not be negative");
        return new ChronVer(year, month, day, Changeset.of(changeset));
    }

    public static final class Changeset
    implements Comparable<Changeset> {
        private final String identifier;
        private final int change;
        private final String tag;
        private final int change2;

        private Changeset(String identifier) {
            if (StringUtils.isNotBlank((String)identifier)) {
                this.identifier = identifier.trim();
                Matcher matcher = CHANGESET.matcher(identifier);
                if (matcher.matches()) {
                    this.change = Integer.parseInt(matcher.group(1));
                    this.tag = matcher.group(2);
                    String c = matcher.group(3);
                    this.change2 = StringUtils.isNotBlank((String)c) ? Integer.parseInt(c) : 0;
                } else {
                    this.change = 0;
                    this.tag = null;
                    this.change2 = 0;
                }
            } else {
                this.identifier = "";
                this.change = 0;
                this.tag = null;
                this.change2 = 0;
            }
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public boolean isEmpty() {
            return StringUtils.isBlank((String)this.identifier);
        }

        public boolean hasTag() {
            return StringUtils.isNotBlank((String)this.tag);
        }

        public boolean hasChange2() {
            return this.change2 != 0;
        }

        public int getChange() {
            return this.change;
        }

        public String getTag() {
            return this.tag;
        }

        public int getChange2() {
            return this.change2;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "";
            }
            StringBuilder b = new StringBuilder().append(this.change);
            if (this.hasTag()) {
                b.append("-").append(this.tag);
            }
            if (this.hasChange2()) {
                b.append(".").append(this.change2);
            }
            return b.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Changeset changeset = (Changeset)o;
            return this.identifier.equals(changeset.identifier);
        }

        public int hashCode() {
            return Objects.hash(this.identifier);
        }

        @Override
        public int compareTo(Changeset other) {
            if (other == null) {
                return -1;
            }
            if (this.isEmpty() && other.isEmpty()) {
                return 0;
            }
            if (this.isEmpty() && !other.isEmpty()) {
                return 1;
            }
            if (!this.isEmpty() && other.isEmpty()) {
                return -1;
            }
            int c = this.change - other.change;
            if (c == 0 && this.hasTag()) {
                c = this.tag.compareTo(other.tag);
            }
            if (c == 0 && this.hasChange2()) {
                c = this.change2 - other.change2;
            }
            return c;
        }

        public static Changeset of(String str) {
            return new Changeset(str);
        }
    }
}

