/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.util.concurrent.Callable;
import org.jreleaser.cli.Banner;
import org.jreleaser.cli.BaseCommand;
import org.jreleaser.cli.HaltExecutionException;
import org.jreleaser.cli.Main;
import org.jreleaser.cli.internal.Colorizer;
import org.jreleaser.model.JReleaserException;

abstract class AbstractCommand
extends BaseCommand
implements Callable<Integer> {
    AbstractCommand() {
    }

    protected abstract Main parent();

    @Override
    public Integer call() {
        this.setup();
        try {
            this.execute();
        }
        catch (HaltExecutionException e) {
            return 1;
        }
        catch (JReleaserException e) {
            Colorizer colorizer = new Colorizer(this.parent().out);
            String message = e.getMessage();
            colorizer.println(message);
            this.printDetails(e.getCause(), message, colorizer);
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace(new Colorizer(this.parent().out));
            return 1;
        }
        return 0;
    }

    protected void setup() {
        Banner.display(this.parent().out);
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "error");
    }

    protected void printDetails(Throwable throwable, String message, Colorizer colorizer) {
        if (throwable == null) {
            return;
        }
        String myMessage = throwable.getMessage();
        if (!message.equals(myMessage)) {
            colorizer.println(myMessage);
        } else {
            this.printDetails(throwable.getCause(), message, colorizer);
        }
    }

    protected abstract void execute();
}

