/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.logging;

import java.io.OutputStream;
import java.io.PrintWriter;
import org.jreleaser.logging.AbstractJReleaserLogger;
import org.slf4j.helpers.MessageFormatter;

public class SimpleJReleaserLoggerAdapter
extends AbstractJReleaserLogger {
    private final PrintWriter out;
    private final Level level;

    public SimpleJReleaserLoggerAdapter() {
        this(System.out, Level.WARN);
    }

    public SimpleJReleaserLoggerAdapter(Level level) {
        this(System.out, level);
    }

    public SimpleJReleaserLoggerAdapter(OutputStream out) {
        this(new PrintWriter(out, true), Level.WARN);
    }

    public SimpleJReleaserLoggerAdapter(OutputStream out, Level level) {
        this(new PrintWriter(out, true), level);
    }

    public SimpleJReleaserLoggerAdapter(PrintWriter out) {
        this(out, Level.WARN);
    }

    public SimpleJReleaserLoggerAdapter(PrintWriter out, Level level) {
        super(new PrintWriter(System.err));
        this.out = out;
        this.level = level;
    }

    @Override
    public void debug(String message) {
        if (this.isLevelEnabled(Level.DEBUG)) {
            String msg = (Object)((Object)Level.DEBUG) + this.formatMessage(message);
            this.out.println(msg);
            this.trace(msg);
        }
    }

    @Override
    public void info(String message) {
        if (this.isLevelEnabled(Level.INFO)) {
            String msg = (Object)((Object)Level.INFO) + this.formatMessage(message);
            this.out.println(msg);
            this.trace(msg);
        }
    }

    @Override
    public void warn(String message) {
        if (this.isLevelEnabled(Level.WARN)) {
            String msg = (Object)((Object)Level.WARN) + this.formatMessage(message);
            this.out.println(msg);
            this.trace(msg);
        }
    }

    @Override
    public void error(String message) {
        if (this.isLevelEnabled(Level.ERROR)) {
            String msg = (Object)((Object)Level.ERROR) + this.formatMessage(message);
            this.out.println(msg);
            this.trace(msg);
        }
    }

    @Override
    public void debug(String message, Object ... args) {
        if (this.isLevelEnabled(Level.DEBUG)) {
            String msg = (Object)((Object)Level.DEBUG) + this.formatMessage(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage());
            this.out.println(msg);
            this.trace(msg);
        }
    }

    @Override
    public void info(String message, Object ... args) {
        if (this.isLevelEnabled(Level.INFO)) {
            String msg = (Object)((Object)Level.INFO) + this.formatMessage(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage());
            this.out.println(msg);
            this.trace(msg);
        }
    }

    @Override
    public void warn(String message, Object ... args) {
        if (this.isLevelEnabled(Level.WARN)) {
            String msg = (Object)((Object)Level.WARN) + this.formatMessage(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage());
            this.out.println(msg);
            this.trace(msg);
        }
    }

    @Override
    public void error(String message, Object ... args) {
        if (this.isLevelEnabled(Level.ERROR)) {
            String msg = (Object)((Object)Level.ERROR) + this.formatMessage(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage());
            this.out.println(msg);
            this.trace(msg);
        }
    }

    @Override
    public void debug(String message, Throwable throwable) {
        if (this.isLevelEnabled(Level.DEBUG)) {
            String msg = (Object)((Object)Level.DEBUG) + this.formatMessage(message);
            this.out.println(msg);
            this.printThrowable(throwable);
            this.trace(msg, throwable);
        }
    }

    @Override
    public void info(String message, Throwable throwable) {
        if (this.isLevelEnabled(Level.INFO)) {
            String msg = (Object)((Object)Level.INFO) + this.formatMessage(message);
            this.out.println(msg);
            this.printThrowable(throwable);
            this.trace(msg, throwable);
        }
    }

    @Override
    public void warn(String message, Throwable throwable) {
        if (this.isLevelEnabled(Level.WARN)) {
            String msg = (Object)((Object)Level.WARN) + this.formatMessage(message);
            this.out.println(msg);
            this.printThrowable(throwable);
            this.trace(msg, throwable);
        }
    }

    @Override
    public void error(String message, Throwable throwable) {
        if (this.isLevelEnabled(Level.ERROR)) {
            String msg = (Object)((Object)Level.ERROR) + this.formatMessage(message);
            this.out.println(msg);
            this.printThrowable(throwable);
            this.trace(msg, throwable);
        }
    }

    private void printThrowable(Throwable throwable) {
        if (null != throwable) {
            throwable.printStackTrace(this.out);
            this.out.flush();
        }
    }

    private boolean isLevelEnabled(Level requested) {
        return requested.ordinal() >= this.level.ordinal();
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR;


        public String toString() {
            return "[" + this.name() + "] " + (this.name().length() == 4 ? " " : "");
        }
    }
}

