/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.http;

import feign.form.FormData;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.Http;
import org.jreleaser.model.api.upload.HttpUploader;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.spi.upload.UploadException;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.commons.AbstractArtifactUploader;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.util.StringUtils;

public class HttpArtifactUploader
extends AbstractArtifactUploader<HttpUploader, org.jreleaser.model.internal.upload.HttpUploader> {
    private org.jreleaser.model.internal.upload.HttpUploader uploader;

    public HttpArtifactUploader(JReleaserContext context) {
        super(context);
    }

    public org.jreleaser.model.internal.upload.HttpUploader getUploader() {
        return this.uploader;
    }

    public void setUploader(org.jreleaser.model.internal.upload.HttpUploader uploader) {
        this.uploader = uploader;
    }

    public String getType() {
        return "http";
    }

    public void upload(String name) throws UploadException {
        List artifacts = this.collectArtifacts();
        if (artifacts.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"artifacts.no.match", (Object[])new Object[0]));
        }
        String username = this.uploader.getResolvedUsername();
        String password = this.uploader.getResolvedPassword();
        for (Artifact artifact : artifacts) {
            Path path = artifact.getEffectivePath(this.context);
            this.context.getLogger().info(" - {}", new Object[]{path.getFileName()});
            if (this.context.isDryrun()) continue;
            try {
                FormData data = ClientUtils.toFormData((Path)path);
                LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
                switch (this.uploader.resolveAuthorization()) {
                    case NONE: {
                        break;
                    }
                    case BASIC: {
                        String auth = username + ":" + password;
                        byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes());
                        auth = new String(encodedAuth);
                        headers.put("Authorization", "Basic " + auth);
                        break;
                    }
                    case BEARER: {
                        headers.put("Authorization", "Bearer " + password);
                    }
                }
                this.resolveHeaders(artifact, headers);
                if (this.uploader.getMethod() == Http.Method.POST) {
                    ClientUtils.postFile((JReleaserLogger)this.context.getLogger(), (String)this.uploader.getResolvedUploadUrl(this.context, artifact), (int)this.uploader.getConnectTimeout(), (int)this.uploader.getReadTimeout(), (FormData)data, headers);
                    continue;
                }
                ClientUtils.putFile((JReleaserLogger)this.context.getLogger(), (String)this.uploader.getResolvedUploadUrl(this.context, artifact), (int)this.uploader.getConnectTimeout(), (int)this.uploader.getReadTimeout(), (FormData)data, headers);
            }
            catch (IOException e) {
                this.context.getLogger().trace((Throwable)e);
                throw new UploadException(RB.$((String)"ERROR_unexpected_upload", (Object[])new Object[]{this.context.getBasedir().relativize(path)}), (Throwable)e);
            }
        }
    }

    private void resolveHeaders(Artifact artifact, Map<String, String> headers) {
        Map props = this.uploader.artifactProps(this.context, artifact);
        this.uploader.getHeaders().forEach((k, v) -> {
            String value = Templates.resolveTemplate((String)v, (Map)props);
            if (StringUtils.isNotBlank((String)value)) {
                headers.put((String)k, value);
            }
        });
    }
}

