/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.deploy.maven;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.deploy.Deployer;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.deploy.maven.AbstractMavenDeployer;
import org.jreleaser.model.internal.deploy.maven.ArtifactoryMavenDeployer;
import org.jreleaser.model.internal.deploy.maven.GiteaMavenDeployer;
import org.jreleaser.model.internal.deploy.maven.GithubMavenDeployer;
import org.jreleaser.model.internal.deploy.maven.GitlabMavenDeployer;
import org.jreleaser.model.internal.deploy.maven.MavenDeployer;
import org.jreleaser.model.internal.deploy.maven.Nexus2MavenDeployer;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.util.Env;

public final class Maven
extends AbstractModelObject<Maven>
implements Domain,
Activatable {
    private final Map<String, ArtifactoryMavenDeployer> artifactory = new LinkedHashMap<String, ArtifactoryMavenDeployer>();
    private final Map<String, GiteaMavenDeployer> gitea = new LinkedHashMap<String, GiteaMavenDeployer>();
    private final Map<String, GithubMavenDeployer> github = new LinkedHashMap<String, GithubMavenDeployer>();
    private final Map<String, GitlabMavenDeployer> gitlab = new LinkedHashMap<String, GitlabMavenDeployer>();
    private final Map<String, Nexus2MavenDeployer> nexus2 = new LinkedHashMap<String, Nexus2MavenDeployer>();
    private Active active;
    @JsonIgnore
    private boolean enabled = true;
    private final org.jreleaser.model.api.deploy.maven.Maven immutable = new org.jreleaser.model.api.deploy.maven.Maven(){
        private Map<String, ? extends org.jreleaser.model.api.deploy.maven.ArtifactoryMavenDeployer> artifactory;
        private Map<String, ? extends org.jreleaser.model.api.deploy.maven.GiteaMavenDeployer> gitea;
        private Map<String, ? extends org.jreleaser.model.api.deploy.maven.GithubMavenDeployer> github;
        private Map<String, ? extends org.jreleaser.model.api.deploy.maven.GitlabMavenDeployer> gitlab;
        private Map<String, ? extends org.jreleaser.model.api.deploy.maven.Nexus2MavenDeployer> nexus2;

        public Map<String, ? extends org.jreleaser.model.api.deploy.maven.ArtifactoryMavenDeployer> getArtifactory() {
            if (null == this.artifactory) {
                this.artifactory = Maven.this.artifactory.values().stream().map(ArtifactoryMavenDeployer::asImmutable).collect(Collectors.toMap(Deployer::getName, Function.identity()));
            }
            return this.artifactory;
        }

        public Map<String, ? extends org.jreleaser.model.api.deploy.maven.GiteaMavenDeployer> getGitea() {
            if (null == this.gitea) {
                this.gitea = Maven.this.gitea.values().stream().map(GiteaMavenDeployer::asImmutable).collect(Collectors.toMap(Deployer::getName, Function.identity()));
            }
            return this.gitea;
        }

        public Map<String, ? extends org.jreleaser.model.api.deploy.maven.GithubMavenDeployer> getGithub() {
            if (null == this.github) {
                this.github = Maven.this.github.values().stream().map(GithubMavenDeployer::asImmutable).collect(Collectors.toMap(Deployer::getName, Function.identity()));
            }
            return this.github;
        }

        public Map<String, ? extends org.jreleaser.model.api.deploy.maven.GitlabMavenDeployer> getGitlab() {
            if (null == this.gitlab) {
                this.gitlab = Maven.this.gitlab.values().stream().map(GitlabMavenDeployer::asImmutable).collect(Collectors.toMap(Deployer::getName, Function.identity()));
            }
            return this.gitlab;
        }

        public Map<String, ? extends org.jreleaser.model.api.deploy.maven.Nexus2MavenDeployer> getNexus2() {
            if (null == this.nexus2) {
                this.nexus2 = Maven.this.nexus2.values().stream().map(Nexus2MavenDeployer::asImmutable).collect(Collectors.toMap(Deployer::getName, Function.identity()));
            }
            return this.nexus2;
        }

        public Active getActive() {
            return Maven.this.active;
        }

        public boolean isEnabled() {
            return Maven.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Maven.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.deploy.maven.Maven asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Maven source) {
        this.active = this.merge(this.active, source.active);
        this.enabled = this.merge(this.enabled, source.enabled);
        this.setArtifactory(this.mergeModel(this.artifactory, source.artifactory));
        this.setGitea(this.mergeModel(this.gitea, source.gitea));
        this.setGithub(this.mergeModel(this.github, source.github));
        this.setGitlab(this.mergeModel(this.gitlab, source.gitlab));
        this.setNexus2(this.mergeModel(this.nexus2, source.nexus2));
    }

    public boolean isSet() {
        return !this.artifactory.isEmpty() || !this.gitea.isEmpty() || !this.github.isEmpty() || !this.gitlab.isEmpty() || !this.nexus2.isEmpty();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.active != null;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.setActive(Env.resolveOrDefault((String)"deploy.maven.active", (String)"", (String)"ALWAYS"));
        }
        this.enabled = this.active.check((Active.Releaseable)project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of((String)str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    public Optional<? extends MavenDeployer> getMavenDeployer(String type, String name) {
        switch (type) {
            case "artifactory": {
                return Optional.ofNullable(this.artifactory.get(name));
            }
            case "gitea": {
                return Optional.ofNullable(this.gitea.get(name));
            }
            case "github": {
                return Optional.ofNullable(this.github.get(name));
            }
            case "gitlab": {
                return Optional.ofNullable(this.gitlab.get(name));
            }
            case "nexus2": {
                return Optional.ofNullable(this.nexus2.get(name));
            }
        }
        return Optional.empty();
    }

    public Optional<? extends MavenDeployer> getActiveMavenDeployer(String type, String name) {
        switch (type) {
            case "artifactory": {
                return this.getActiveArtifactory(name);
            }
            case "gitea": {
                return this.getActiveGitea(name);
            }
            case "github": {
                return this.getActiveGithub(name);
            }
            case "gitlab": {
                return this.getActiveGitlab(name);
            }
            case "nexus2": {
                return this.getActiveNexus2(name);
            }
        }
        return Optional.empty();
    }

    public Optional<ArtifactoryMavenDeployer> getActiveArtifactory(String name) {
        return this.artifactory.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.getName())).findFirst();
    }

    public Optional<GiteaMavenDeployer> getActiveGitea(String name) {
        return this.gitea.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.getName())).findFirst();
    }

    public Optional<GithubMavenDeployer> getActiveGithub(String name) {
        return this.github.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.getName())).findFirst();
    }

    public Optional<GitlabMavenDeployer> getActiveGitlab(String name) {
        return this.gitlab.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.getName())).findFirst();
    }

    public Optional<Nexus2MavenDeployer> getActiveNexus2(String name) {
        return this.nexus2.values().stream().filter(Activatable::isEnabled).filter(a -> name.equals(a.getName())).findFirst();
    }

    public List<ArtifactoryMavenDeployer> getActiveArtifactories() {
        return this.artifactory.values().stream().filter(AbstractMavenDeployer::isEnabled).collect(Collectors.toList());
    }

    public Map<String, ArtifactoryMavenDeployer> getArtifactory() {
        return this.artifactory;
    }

    public void setArtifactory(Map<String, ArtifactoryMavenDeployer> artifactory) {
        this.artifactory.clear();
        this.artifactory.putAll(artifactory);
    }

    public void addArtifactory(ArtifactoryMavenDeployer artifactory) {
        this.artifactory.put(artifactory.getName(), artifactory);
    }

    public List<GiteaMavenDeployer> getActiveGiteas() {
        return this.gitea.values().stream().filter(AbstractMavenDeployer::isEnabled).collect(Collectors.toList());
    }

    public Map<String, GiteaMavenDeployer> getGitea() {
        return this.gitea;
    }

    public void setGitea(Map<String, GiteaMavenDeployer> gitea) {
        this.gitea.clear();
        this.gitea.putAll(gitea);
    }

    public void addGitea(GiteaMavenDeployer gitea) {
        this.gitea.put(gitea.getName(), gitea);
    }

    public List<GithubMavenDeployer> getActiveGithubs() {
        return this.github.values().stream().filter(AbstractMavenDeployer::isEnabled).collect(Collectors.toList());
    }

    public Map<String, GithubMavenDeployer> getGithub() {
        return this.github;
    }

    public void setGithub(Map<String, GithubMavenDeployer> github) {
        this.github.clear();
        this.github.putAll(github);
    }

    public void addGithub(GithubMavenDeployer github) {
        this.github.put(github.getName(), github);
    }

    public List<GitlabMavenDeployer> getActiveGitlabs() {
        return this.gitlab.values().stream().filter(AbstractMavenDeployer::isEnabled).collect(Collectors.toList());
    }

    public Map<String, GitlabMavenDeployer> getGitlab() {
        return this.gitlab;
    }

    public void setGitlab(Map<String, GitlabMavenDeployer> gitlab) {
        this.gitlab.clear();
        this.gitlab.putAll(gitlab);
    }

    public void addGitlab(GitlabMavenDeployer gitlab) {
        this.gitlab.put(gitlab.getName(), gitlab);
    }

    public List<Nexus2MavenDeployer> getActiveNexus2s() {
        return this.nexus2.values().stream().filter(AbstractMavenDeployer::isEnabled).collect(Collectors.toList());
    }

    public Map<String, Nexus2MavenDeployer> getNexus2() {
        return this.nexus2;
    }

    public void setNexus2(Map<String, Nexus2MavenDeployer> nexus2) {
        this.nexus2.clear();
        this.nexus2.putAll(nexus2);
    }

    public void addNexus2(Nexus2MavenDeployer nexus2) {
        this.nexus2.put(nexus2.getName(), nexus2);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        List nexus2;
        List gitlab;
        List github;
        List gitea;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.enabled);
        map.put("active", this.active);
        List artifactory = this.artifactory.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList());
        if (!artifactory.isEmpty()) {
            map.put("artifactory", artifactory);
        }
        if (!(gitea = this.gitea.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("gitea", gitea);
        }
        if (!(github = this.github.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("github", github);
        }
        if (!(gitlab = this.gitlab.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("gitlab", gitlab);
        }
        if (!(nexus2 = this.nexus2.values().stream().filter(d -> full || d.isEnabled()).map(d -> d.asMap(full)).collect(Collectors.toList())).isEmpty()) {
            map.put("nexus2", nexus2);
        }
        return map;
    }

    public <A extends MavenDeployer<?>> Map<String, A> findMavenDeployersByType(String deployerType) {
        switch (deployerType) {
            case "artifactory": {
                return this.artifactory;
            }
            case "gitea": {
                return this.gitea;
            }
            case "github": {
                return this.github;
            }
            case "gitlab": {
                return this.gitlab;
            }
            case "nexus2": {
                return this.nexus2;
            }
        }
        return Collections.emptyMap();
    }

    public <A extends MavenDeployer<?>> List<A> findAllActiveMavenDeployers() {
        ArrayList<AbstractMavenDeployer> deployers = new ArrayList<AbstractMavenDeployer>();
        deployers.addAll(this.getActiveArtifactories());
        deployers.addAll(this.getActiveGiteas());
        deployers.addAll(this.getActiveGithubs());
        deployers.addAll(this.getActiveGitlabs());
        deployers.addAll(this.getActiveNexus2s());
        return deployers;
    }
}

