/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.distributions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.common.Artifact;
import org.jreleaser.model.api.common.Java;
import org.jreleaser.model.api.distributions.Distribution;
import org.jreleaser.model.api.packagers.AppImagePackager;
import org.jreleaser.model.api.packagers.AsdfPackager;
import org.jreleaser.model.api.packagers.BrewPackager;
import org.jreleaser.model.api.packagers.ChocolateyPackager;
import org.jreleaser.model.api.packagers.DockerPackager;
import org.jreleaser.model.api.packagers.FlatpakPackager;
import org.jreleaser.model.api.packagers.GofishPackager;
import org.jreleaser.model.api.packagers.JbangPackager;
import org.jreleaser.model.api.packagers.MacportsPackager;
import org.jreleaser.model.api.packagers.ScoopPackager;
import org.jreleaser.model.api.packagers.SdkmanPackager;
import org.jreleaser.model.api.packagers.SnapPackager;
import org.jreleaser.model.api.packagers.SpecPackager;
import org.jreleaser.model.api.platform.Platform;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.ExtraProperties;
import org.jreleaser.model.internal.packagers.Packager;
import org.jreleaser.model.internal.packagers.Packagers;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.SemanticVersion;

public final class Distribution
extends Packagers<Distribution>
implements Domain,
Activatable,
ExtraProperties {
    private final List<String> tags = new ArrayList<String>();
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private final Set<org.jreleaser.model.internal.common.Artifact> artifacts = new LinkedHashSet<org.jreleaser.model.internal.common.Artifact>();
    private final org.jreleaser.model.internal.common.Java java = new org.jreleaser.model.internal.common.Java();
    private final org.jreleaser.model.internal.platform.Platform platform = new org.jreleaser.model.internal.platform.Platform();
    private final Executable executable = new Executable();
    private Active active;
    @JsonIgnore
    private boolean enabled;
    private String name;
    private Distribution.DistributionType type = Distribution.DistributionType.JAVA_BINARY;
    private Stereotype stereotype;
    private final org.jreleaser.model.api.distributions.Distribution immutable = new org.jreleaser.model.api.distributions.Distribution(){
        private Set<? extends Artifact> artifacts;

        public Platform getPlatform() {
            return Distribution.this.platform.asImmutable();
        }

        public Distribution.DistributionType getType() {
            return Distribution.this.type;
        }

        public Stereotype getStereotype() {
            return Distribution.this.stereotype;
        }

        public String getName() {
            return Distribution.this.name;
        }

        public Distribution.Executable getExecutable() {
            return Distribution.this.executable.asImmutable();
        }

        public Set<? extends Artifact> getArtifacts() {
            if (null == this.artifacts) {
                this.artifacts = Distribution.this.artifacts.stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.artifacts;
        }

        public List<String> getTags() {
            return Collections.unmodifiableList(Distribution.this.tags);
        }

        public Java getJava() {
            return Distribution.this.java.asImmutable();
        }

        public Active getActive() {
            return Distribution.this.active;
        }

        public boolean isEnabled() {
            return Distribution.this.isEnabled();
        }

        public String getPrefix() {
            return Distribution.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(Distribution.this.extraProperties);
        }

        public AppImagePackager getAppImage() {
            return Distribution.this.appImage.asImmutable();
        }

        public AsdfPackager getAsdf() {
            return Distribution.this.asdf.asImmutable();
        }

        public BrewPackager getBrew() {
            return Distribution.this.brew.asImmutable();
        }

        public ChocolateyPackager getChocolatey() {
            return Distribution.this.chocolatey.asImmutable();
        }

        public DockerPackager getDocker() {
            return Distribution.this.docker.asImmutable();
        }

        public GofishPackager getGofish() {
            return Distribution.this.gofish.asImmutable();
        }

        public FlatpakPackager getFlatpak() {
            return Distribution.this.flatpak.asImmutable();
        }

        public JbangPackager getJbang() {
            return Distribution.this.jbang.asImmutable();
        }

        public MacportsPackager getMacports() {
            return Distribution.this.macports.asImmutable();
        }

        public ScoopPackager getScoop() {
            return Distribution.this.scoop.asImmutable();
        }

        public SdkmanPackager getSdkman() {
            return Distribution.this.sdkman.asImmutable();
        }

        public SnapPackager getSnap() {
            return Distribution.this.snap.asImmutable();
        }

        public SpecPackager getSpec() {
            return Distribution.this.spec.asImmutable();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Distribution.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.distributions.Distribution asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Distribution source) {
        super.merge(source);
        this.active = this.merge(this.active, source.active);
        this.enabled = this.merge(this.enabled, source.enabled);
        this.name = this.merge(this.name, source.name);
        this.type = this.merge(this.type, source.type);
        this.stereotype = this.merge(this.stereotype, source.stereotype);
        this.setExecutable(source.executable);
        this.setPlatform(source.platform);
        this.setJava(source.java);
        this.setTags(this.merge(this.tags, source.tags));
        this.setExtraProperties(this.merge(this.extraProperties, source.extraProperties));
        this.setArtifacts(this.merge(this.artifacts, source.artifacts));
    }

    public Map<String, Object> props() {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("distributionName", this.name);
        props.put("distributionStereotype", this.getStereotype());
        props.put("distributionExecutable", this.executable.getName());
        props.put("distributionExecutableName", this.executable.getName());
        props.put("distributionExecutableUnix", this.executable.resolveExecutable("linux"));
        props.put("distributionExecutableWindows", this.executable.resolveExecutable("windows"));
        CollectionUtils.safePut((String)"distributionExecutableExtensionUnix", (Object)this.executable.resolveUnixExtension(), props, (boolean)true);
        CollectionUtils.safePut((String)"distributionExecutableExtensionWindows", (Object)this.executable.resolveWindowsExtension(), props, (boolean)true);
        props.put("distributionTagsBySpace", String.join((CharSequence)" ", this.tags));
        props.put("distributionTagsByComma", String.join((CharSequence)",", this.tags));
        props.putAll(this.java.getResolvedExtraProperties());
        CollectionUtils.safePut((String)"distributionJavaGroupId", (Object)this.java.getGroupId(), props, (boolean)true);
        CollectionUtils.safePut((String)"distributionJavaArtifactId", (Object)this.java.getArtifactId(), props, (boolean)true);
        CollectionUtils.safePut((String)"distributionJavaMainClass", (Object)this.java.getMainClass(), props, (boolean)true);
        if (StringUtils.isNotBlank((String)this.java.getVersion())) {
            props.put("distributionJavaVersion", this.java.getVersion());
            SemanticVersion jv = SemanticVersion.of((String)this.java.getVersion());
            CollectionUtils.safePut((String)"distributionJavaVersionMajor", (Object)jv.getMajor(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionMinor", (Object)jv.getMinor(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionPatch", (Object)jv.getPatch(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionTag", (Object)jv.getTag(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionBuild", (Object)jv.getBuild(), props, (boolean)true);
        } else {
            props.put("distributionJavaVersion", "");
            props.put("distributionJavaVersionMajor", "");
            props.put("distributionJavaVersionMinor", "");
            props.put("distributionJavaVersionPatch", "");
            props.put("distributionJavaVersionTag", "");
            props.put("distributionJavaVersionBuild", "");
        }
        return props;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.active = Active.NEVER;
        }
        this.enabled = this.active.check((Active.Releaseable)project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of((String)str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    public org.jreleaser.model.internal.platform.Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(org.jreleaser.model.internal.platform.Platform platform) {
        this.platform.merge(platform);
    }

    @Override
    public String getPrefix() {
        return "distribution";
    }

    public Distribution.DistributionType getType() {
        return this.type;
    }

    public void setType(Distribution.DistributionType type) {
        this.type = type;
    }

    public void setType(String type) {
        this.type = Distribution.DistributionType.of((String)type);
    }

    public Stereotype getStereotype() {
        return this.stereotype;
    }

    public void setStereotype(Stereotype stereotype) {
        this.stereotype = stereotype;
    }

    public void setStereotype(String str) {
        this.setStereotype(Stereotype.of((String)str));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable.merge(executable);
    }

    public Set<org.jreleaser.model.internal.common.Artifact> getArtifacts() {
        return org.jreleaser.model.internal.common.Artifact.sortArtifacts(this.artifacts);
    }

    public void setArtifacts(Set<org.jreleaser.model.internal.common.Artifact> artifacts) {
        this.artifacts.clear();
        this.artifacts.addAll(artifacts);
    }

    public void addArtifacts(Set<org.jreleaser.model.internal.common.Artifact> artifacts) {
        this.artifacts.addAll(artifacts);
    }

    public void addArtifact(org.jreleaser.model.internal.common.Artifact artifact) {
        if (null != artifact) {
            this.artifacts.add(artifact);
        }
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags.clear();
        this.tags.addAll(tags);
    }

    public void addTags(List<String> tags) {
        this.tags.addAll(tags);
    }

    public void addTag(String tag) {
        if (StringUtils.isNotBlank((String)tag)) {
            this.tags.add(tag.trim());
        }
    }

    public org.jreleaser.model.internal.common.Java getJava() {
        return this.java;
    }

    public void setJava(org.jreleaser.model.internal.common.Java java) {
        this.java.merge(java);
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    public void mergeExtraProperties(Map<String, Object> extraProperties) {
        extraProperties.forEach((k, v) -> {
            if (!this.extraProperties.containsKey(k)) {
                this.extraProperties.put((String)k, v);
            }
        });
    }

    public <T extends Packager<?>> T findPackager(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new JReleaserException(RB.$((String)"ERROR_packager_name_not_blank", (Object[])new Object[0]));
        }
        return this.resolvePackager(name);
    }

    public <T extends Packager<?>> T getPackager(String name) {
        T packager = this.findPackager(name);
        if (null != packager) {
            return packager;
        }
        throw new JReleaserException(RB.$((String)"ERROR_packager_not_configured", (Object[])new Object[]{name}));
    }

    private <T extends Packager<?>> T resolvePackager(String name) {
        switch (name.toLowerCase(Locale.ENGLISH).trim()) {
            case "appimage": {
                return (T)this.getAppImage();
            }
            case "asdf": {
                return (T)this.getAsdf();
            }
            case "brew": {
                return (T)this.getBrew();
            }
            case "chocolatey": {
                return (T)this.getChocolatey();
            }
            case "docker": {
                return (T)this.getDocker();
            }
            case "flatpak": {
                return (T)this.getFlatpak();
            }
            case "gofish": {
                return (T)this.getGofish();
            }
            case "jbang": {
                return (T)this.getJbang();
            }
            case "macports": {
                return (T)this.getMacports();
            }
            case "scoop": {
                return (T)this.getScoop();
            }
            case "sdkman": {
                return (T)this.getSdkman();
            }
            case "snap": {
                return (T)this.getSnap();
            }
            case "spec": {
                return (T)this.getSpec();
            }
        }
        throw new JReleaserException(RB.$((String)"ERROR_unsupported_packager", (Object[])new Object[]{name}));
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", this.active);
        props.put("type", this.type);
        props.put("executable", this.executable.asMap(full));
        if (full || this.platform.isSet()) {
            props.put("platform", this.platform.asMap(full));
        }
        LinkedHashMap<String, Map<String, Object>> mappedArtifacts = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (org.jreleaser.model.internal.common.Artifact artifact : this.getArtifacts()) {
            mappedArtifacts.put("artifact " + i++, artifact.asMap(full));
        }
        props.put("artifacts", mappedArtifacts);
        props.put("tags", this.tags);
        props.put("stereotype", this.stereotype);
        props.put("extraProperties", this.getResolvedExtraProperties());
        if (this.java.isEnabled()) {
            props.put("java", this.java.asMap(full));
        }
        props.putAll(super.asMap(full));
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.name, props);
        return map;
    }

    public static class Executable
    extends AbstractModelObject<Executable>
    implements Domain {
        private String name;
        private String unixExtension;
        private String windowsExtension = "bat";
        private final Distribution.Executable immutable = new Distribution.Executable(){

            public String getName() {
                return name;
            }

            public String getUnixExtension() {
                return unixExtension;
            }

            public String getWindowsExtension() {
                return windowsExtension;
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public Distribution.Executable asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Executable source) {
            this.name = this.merge(this.name, source.name);
            this.unixExtension = this.merge(this.unixExtension, source.unixExtension);
            this.windowsExtension = this.merge(this.windowsExtension, source.windowsExtension);
        }

        public String resolveExecutable(String platform) {
            if (PlatformUtils.isWindows((String)platform)) {
                return this.name + this.resolveWindowsExtension();
            }
            return this.name + this.resolveUnixExtension();
        }

        public String resolveUnixExtension() {
            return StringUtils.isNotBlank((String)this.unixExtension) ? "." + this.unixExtension : "";
        }

        public String resolveWindowsExtension() {
            return "." + this.windowsExtension;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUnixExtension() {
            return this.unixExtension;
        }

        public void setUnixExtension(String unixExtension) {
            this.unixExtension = unixExtension;
        }

        public String getWindowsExtension() {
            return this.windowsExtension;
        }

        public void setWindowsExtension(String windowsExtension) {
            this.windowsExtension = windowsExtension;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("name", this.name);
            map.put("unixExtension", this.unixExtension);
            map.put("windowsExtension", this.windowsExtension);
            return map;
        }
    }
}

