/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.internal.packagers.AbstractPackager;
import org.jreleaser.model.internal.packagers.TemplatePackager;
import org.jreleaser.util.StringUtils;

public abstract class AbstractTemplatePackager<A extends org.jreleaser.model.api.packagers.TemplatePackager, S extends AbstractTemplatePackager<A, S>>
extends AbstractPackager<A, S>
implements TemplatePackager<A> {
    protected final List<String> skipTemplates = new ArrayList<String>();
    protected String templateDirectory;

    protected AbstractTemplatePackager(String type) {
        super(type);
    }

    @Override
    public void merge(S source) {
        super.merge(source);
        this.templateDirectory = this.merge(this.templateDirectory, ((AbstractTemplatePackager)source).templateDirectory);
        this.setSkipTemplates(this.merge(this.skipTemplates, ((AbstractTemplatePackager)source).skipTemplates));
    }

    @Override
    public String getTemplateDirectory() {
        return this.templateDirectory;
    }

    @Override
    public void setTemplateDirectory(String templateDirectory) {
        this.templateDirectory = templateDirectory;
    }

    @Override
    public List<String> getSkipTemplates() {
        return this.skipTemplates;
    }

    @Override
    public void setSkipTemplates(List<String> skipTemplates) {
        this.skipTemplates.clear();
        this.skipTemplates.addAll(skipTemplates);
    }

    @Override
    public void addSkipTemplates(List<String> templates) {
        this.skipTemplates.addAll(templates);
    }

    @Override
    public void addSkipTemplate(String template) {
        if (StringUtils.isNotBlank((String)template)) {
            this.skipTemplates.add(template.trim());
        }
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("templateDirectory", this.templateDirectory);
        props.put("skipTemplates", this.skipTemplates);
    }
}

