/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Sdkman;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.TimeoutAware;
import org.jreleaser.model.internal.packagers.AbstractPackager;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Env;
import org.jreleaser.util.FileType;
import org.jreleaser.util.StringUtils;

public final class SdkmanPackager
extends AbstractPackager<org.jreleaser.model.api.packagers.SdkmanPackager, SdkmanPackager>
implements TimeoutAware {
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private Sdkman.Command command;
    private String candidate;
    private String releaseNotesUrl;
    private String consumerKey;
    private String consumerToken;
    private int connectTimeout;
    private int readTimeout;
    @JsonIgnore
    private boolean published;
    private final org.jreleaser.model.api.packagers.SdkmanPackager immutable = new org.jreleaser.model.api.packagers.SdkmanPackager(){

        public String getCandidate() {
            return SdkmanPackager.this.candidate;
        }

        public String getReleaseNotesUrl() {
            return SdkmanPackager.this.releaseNotesUrl;
        }

        public Sdkman.Command getCommand() {
            return SdkmanPackager.this.command;
        }

        public String getConsumerKey() {
            return SdkmanPackager.this.consumerKey;
        }

        public String getConsumerToken() {
            return SdkmanPackager.this.consumerToken;
        }

        public boolean isPublished() {
            return SdkmanPackager.this.isPublished();
        }

        public Integer getConnectTimeout() {
            return SdkmanPackager.this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return SdkmanPackager.this.readTimeout;
        }

        public String getType() {
            return SdkmanPackager.this.type;
        }

        public String getDownloadUrl() {
            return SdkmanPackager.this.downloadUrl;
        }

        public boolean supportsPlatform(String platform) {
            return SdkmanPackager.this.supportsPlatform(platform);
        }

        public boolean supportsDistribution(Distribution.DistributionType distributionType) {
            return SdkmanPackager.this.supportsDistribution(distributionType);
        }

        public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
            return SdkmanPackager.this.getSupportedFileExtensions(distributionType);
        }

        public Set<Stereotype> getSupportedStereotypes() {
            return SdkmanPackager.this.getSupportedStereotypes();
        }

        public boolean isSnapshotSupported() {
            return SdkmanPackager.this.isSnapshotSupported();
        }

        public boolean isContinueOnError() {
            return SdkmanPackager.this.isContinueOnError();
        }

        public Active getActive() {
            return SdkmanPackager.this.active;
        }

        public boolean isEnabled() {
            return SdkmanPackager.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(SdkmanPackager.this.asMap(full));
        }

        public String getPrefix() {
            return SdkmanPackager.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(SdkmanPackager.this.extraProperties);
        }
    };

    public SdkmanPackager() {
        super("sdkman");
    }

    @Override
    public org.jreleaser.model.api.packagers.SdkmanPackager asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(SdkmanPackager source) {
        super.merge(source);
        this.candidate = this.merge(this.candidate, source.candidate);
        this.releaseNotesUrl = this.merge(this.releaseNotesUrl, source.releaseNotesUrl);
        this.command = this.merge(this.command, source.command);
        this.consumerKey = this.merge(this.consumerKey, source.consumerKey);
        this.consumerToken = this.merge(this.consumerToken, source.consumerToken);
        this.connectTimeout = this.merge(this.connectTimeout, source.connectTimeout);
        this.readTimeout = this.merge(this.readTimeout, source.readTimeout);
        this.published = this.merge(this.published, source.published);
    }

    public String getResolvedConsumerKey() {
        return Env.env((String)"SDKMAN_CONSUMER_KEY", (String)this.consumerKey);
    }

    public String getResolvedConsumerToken() {
        return Env.env((String)"SDKMAN_CONSUMER_TOKEN", (String)this.consumerToken);
    }

    public String getCandidate() {
        return this.candidate;
    }

    public void setCandidate(String candidate) {
        this.candidate = candidate;
    }

    public String getReleaseNotesUrl() {
        return this.releaseNotesUrl;
    }

    public void setReleaseNotesUrl(String releaseNotesUrl) {
        this.releaseNotesUrl = releaseNotesUrl;
    }

    public Sdkman.Command getCommand() {
        return this.command;
    }

    public void setCommand(Sdkman.Command command) {
        this.command = command;
    }

    public void setCommand(String str) {
        this.setCommand(Sdkman.Command.of((String)str));
    }

    public boolean isCommandSet() {
        return this.command != null;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerToken() {
        return this.consumerToken;
    }

    public void setConsumerToken(String consumerToken) {
        this.consumerToken = consumerToken;
    }

    @Override
    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean isPublished() {
        return this.published;
    }

    public void setPublished(boolean published) {
        this.published = published;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("candidate", this.candidate);
        props.put("command", this.command);
        props.put("releaseNotesUrl", this.releaseNotesUrl);
        props.put("connectTimeout", this.connectTimeout);
        props.put("readTimeout", this.readTimeout);
        props.put("consumerKey", StringUtils.isNotBlank((String)this.getResolvedConsumerKey()) ? "************" : "**unset**");
        props.put("consumerToken", StringUtils.isNotBlank((String)this.getResolvedConsumerToken()) ? "************" : "**unset**");
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return true;
    }

    @Override
    public boolean supportsDistribution(Distribution.DistributionType distributionType) {
        return SUPPORTED.containsKey(distributionType);
    }

    @Override
    public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault(distributionType, Collections.emptySet()));
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get("skipSdkman"));
    }

    static {
        Set extensions = CollectionUtils.setOf((Object[])new String[]{FileType.ZIP.extension()});
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, extensions);
    }
}

