/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.deploy.maven;

import java.util.Locale;
import java.util.Map;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.deploy.maven.GiteaMavenDeployer;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.deploy.maven.MavenDeployersValidator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class GiteaMavenDeployerValidator
extends Validator {
    public static void validateGiteaMavenDeployer(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, GiteaMavenDeployer> gitea = context.getModel().getDeploy().getMaven().getGitea();
        if (!gitea.isEmpty()) {
            context.getLogger().debug("deploy.maven.gitea");
        }
        for (Map.Entry<String, GiteaMavenDeployer> e : gitea.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig()) continue;
            GiteaMavenDeployerValidator.validateGiteaMavenDeployer(context, mode, e.getValue(), errors);
        }
    }

    private static void validateGiteaMavenDeployer(JReleaserContext context, JReleaserContext.Mode mode, GiteaMavenDeployer mavenDeployer, Errors errors) {
        MavenDeployersValidator.validateMavenDeployer(context, mode, mavenDeployer, errors);
        String baseEnvKey = mavenDeployer.getType().toLowerCase(Locale.ENGLISH);
        mavenDeployer.setUsername(GiteaMavenDeployerValidator.checkProperty(context, baseEnvKey + "_" + Env.toVar((String)mavenDeployer.getName()) + "_USERNAME", mavenDeployer.getType() + ".username", mavenDeployer.getUsername(), errors, true));
        if (StringUtils.isBlank((String)mavenDeployer.getUsername())) {
            mavenDeployer.setUsername(context.getModel().getRelease().getReleaser().getResolvedUsername());
        }
    }
}

