/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.packagers;

import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.AsdfPackager;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.validation.common.ExtraPropertiesValidator;
import org.jreleaser.model.internal.validation.common.TemplateValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.distributions.DistributionsValidator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class AsdfPackagerValidator
extends Validator {
    public static void validateAsdf(JReleaserContext context, Distribution distribution, AsdfPackager packager, Errors errors) {
        context.getLogger().debug("distribution.{}.asdf", new Object[]{distribution.getName()});
        JReleaserModel model = context.getModel();
        AsdfPackager parentPackager = model.getPackagers().getAsdf();
        if (!packager.isActiveSet() && parentPackager.isActiveSet()) {
            packager.setActive(parentPackager.getActive());
        }
        if (!packager.resolveEnabled(context.getModel().getProject(), distribution)) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        BaseReleaser<?, ?> service = model.getRelease().getReleaser();
        if (!service.isReleaseSupported()) {
            context.getLogger().debug(RB.$((String)"validation.disabled.release", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        List<Artifact> candidateArtifacts = packager.resolveCandidateArtifacts(context, distribution);
        if (candidateArtifacts.size() == 0) {
            packager.setActive(Active.NEVER);
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        if (candidateArtifacts.stream().filter(artifact -> StringUtils.isBlank((String)artifact.getPlatform())).count() > 1L) {
            errors.configuration(RB.$((String)"validation_packager_multiple_artifacts", (Object[])new Object[]{"distribution." + distribution.getName() + ".asdf"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.multiple.artifacts", (Object[])new Object[0]));
            packager.disable();
            return;
        }
        if (StringUtils.isBlank((String)packager.getToolCheck()) && StringUtils.isNotBlank((String)parentPackager.getToolCheck())) {
            packager.setToolCheck(parentPackager.getToolCheck());
        }
        if (StringUtils.isBlank((String)packager.getToolCheck())) {
            packager.setToolCheck("{{distributionExecutable}} --version");
        }
        if (StringUtils.isBlank((String)packager.getRepository().getName())) {
            packager.getRepository().setName("asdf-" + distribution.getName());
        }
        packager.getRepository().setTapName("asdf-" + distribution.getName());
        AsdfPackagerValidator.validateCommitAuthor(packager, parentPackager);
        AsdfPackager.AsdfRepository repository = packager.getRepository();
        repository.resolveEnabled(model.getProject());
        AsdfPackagerValidator.validateTap(context, distribution, repository, parentPackager.getRepository(), "asdf.repository");
        TemplateValidator.validateTemplate(context, distribution, packager, parentPackager, errors);
        ExtraPropertiesValidator.mergeExtraProperties(packager, parentPackager);
        AsdfPackagerValidator.validateContinueOnError(packager, parentPackager);
        if (StringUtils.isBlank((String)packager.getDownloadUrl())) {
            packager.setDownloadUrl(parentPackager.getDownloadUrl());
        }
        DistributionsValidator.validateArtifactPlatforms(context, distribution, packager, candidateArtifacts, errors);
    }
}

