/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.net.MalformedURLException;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHWorkflow;
import org.kohsuke.github.GHWorkflowsPage;
import org.kohsuke.github.GitHubPageIterator;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.Requester;

class GHWorkflowsIterable
extends PagedIterable<GHWorkflow> {
    private final transient GHRepository owner;
    private GHWorkflowsPage result;

    public GHWorkflowsIterable(GHRepository owner) {
        this.owner = owner;
    }

    @Override
    @Nonnull
    public PagedIterator<GHWorkflow> _iterator(int pageSize) {
        try {
            GitHubRequest request = ((Requester)this.owner.getRoot().createRequest().withUrlPath(this.owner.getApiTailUrl("actions/workflows"), new String[0])).build();
            return new PagedIterator<GHWorkflow>(this.adapt(GitHubPageIterator.create(this.owner.getRoot().getClient(), GHWorkflowsPage.class, request, pageSize)), null);
        }
        catch (MalformedURLException e) {
            throw new GHException("Malformed URL", e);
        }
    }

    protected Iterator<GHWorkflow[]> adapt(final Iterator<GHWorkflowsPage> base) {
        return new Iterator<GHWorkflow[]>(){

            @Override
            public boolean hasNext() {
                return base.hasNext();
            }

            @Override
            public GHWorkflow[] next() {
                GHWorkflowsPage v = (GHWorkflowsPage)base.next();
                if (GHWorkflowsIterable.this.result == null) {
                    GHWorkflowsIterable.this.result = v;
                }
                return v.getWorkflows(GHWorkflowsIterable.this.owner);
            }
        };
    }
}

