/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.zulip;

import feign.RequestInterceptor;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Encoder;
import feign.form.FormEncoder;
import feign.jackson.JacksonEncoder;
import java.util.Objects;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.zulip.ZulipException;
import org.jreleaser.sdk.zulip.api.Message;
import org.jreleaser.sdk.zulip.api.ZulipAPI;
import org.jreleaser.util.StringUtils;

public class ZulipSdk {
    private final JReleaserLogger logger;
    private final ZulipAPI api;
    private final boolean dryrun;

    private ZulipSdk(JReleaserLogger logger, String apiHost, String account, String apiKey, int connectTimeout, int readTimeout, boolean dryrun) {
        Objects.requireNonNull(logger, "'logger' must not be null");
        StringUtils.requireNonBlank((String)apiHost, (String)"'apiHost' must not be blank");
        StringUtils.requireNonBlank((String)account, (String)"'account' must not be blank");
        StringUtils.requireNonBlank((String)apiKey, (String)"'apiKey' must not be blank");
        this.logger = logger;
        this.dryrun = dryrun;
        this.api = (ZulipAPI)ClientUtils.builder((JReleaserLogger)logger, (int)connectTimeout, (int)readTimeout).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder())).requestInterceptor((RequestInterceptor)new BasicAuthRequestInterceptor(account, apiKey)).target(ZulipAPI.class, apiHost);
        this.logger.debug(RB.$((String)"workflow.dryrun", (Object[])new Object[0]), new Object[]{dryrun});
    }

    public void message(String channel, String subject, String message) throws ZulipException {
        Message payload = Message.of(channel, subject, message);
        this.logger.debug("zulip.message: " + payload);
        this.wrap(() -> this.api.message(payload));
    }

    private void wrap(Runnable runnable) throws ZulipException {
        try {
            if (!this.dryrun) {
                runnable.run();
            }
        }
        catch (RestAPIException e) {
            this.logger.trace((Throwable)e);
            throw new ZulipException(RB.$((String)"sdk.operation.failed", (Object[])new Object[]{"Zulip"}), e);
        }
    }

    public static Builder builder(JReleaserLogger logger) {
        return new Builder(logger);
    }

    static class Builder {
        private final JReleaserLogger logger;
        private boolean dryrun;
        private String account;
        private String apiKey;
        private String apiHost;
        private int connectTimeout = 20;
        private int readTimeout = 60;

        private Builder(JReleaserLogger logger) {
            this.logger = Objects.requireNonNull(logger, "'logger' must not be null");
        }

        public Builder dryrun(boolean dryrun) {
            this.dryrun = dryrun;
            return this;
        }

        public Builder account(String account) {
            this.account = StringUtils.requireNonBlank((String)account, (String)"'account' must not be blank").trim();
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = StringUtils.requireNonBlank((String)apiKey, (String)"'apiKey' must not be blank").trim();
            return this;
        }

        public Builder apiHost(String apiHost) {
            this.apiHost = StringUtils.requireNonBlank((String)apiHost, (String)"'apiHost' must not be blank").trim();
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        private void validate() {
            StringUtils.requireNonBlank((String)this.apiHost, (String)"'apiHost' must not be blank");
            StringUtils.requireNonBlank((String)this.account, (String)"'account' must not be blank");
            StringUtils.requireNonBlank((String)this.apiKey, (String)"'apiKey' must not be blank");
        }

        public ZulipSdk build() {
            this.validate();
            return new ZulipSdk(this.logger, this.apiHost, this.account, this.apiKey, this.connectTimeout, this.readTimeout, this.dryrun);
        }
    }
}

