/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.config.toml;

import com.fasterxml.jackson.dataformat.toml.TomlMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import org.jreleaser.config.JReleaserConfigParser;
import org.jreleaser.model.internal.JReleaserModel;
import org.jreleaser.util.StringUtils;

public class TomlJReleaserConfigParser
implements JReleaserConfigParser {
    public String getPreferredFileExtension() {
        return "toml";
    }

    public boolean supports(Path configFile) {
        return this.supports(configFile.getFileName().toString());
    }

    public boolean supports(String resource) {
        return StringUtils.isNotBlank((String)resource) && resource.endsWith(".toml");
    }

    public void validate(Path configFile) throws IOException {
    }

    public JReleaserModel parse(InputStream inputStream) throws IOException {
        TomlMapper mapper = (TomlMapper)TomlMapper.builder().build();
        return (JReleaserModel)mapper.readValue(inputStream, JReleaserModel.class);
    }

    public <T> T load(Class<T> type, InputStream inputStream) throws IOException {
        TomlMapper mapper = (TomlMapper)TomlMapper.builder().build();
        return (T)mapper.readValue(inputStream, type);
    }

    public Map<String, String> properties(InputStream inputStream) throws IOException {
        TomlMapper mapper = (TomlMapper)TomlMapper.builder().build();
        return (Map)mapper.readValue(inputStream, Map.class);
    }
}

