/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.nio.file.Path;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.AsdfPackager;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.release.GithubReleaser;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.mustache.Templates;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.templates.TemplateUtils;

public class AsdfPackagerProcessor
extends AbstractRepositoryPackagerProcessor<AsdfPackager> {
    public AsdfPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(distribution, props);
    }

    @Override
    protected void fillPackagerProperties(Map<String, Object> props, Distribution distribution) throws PackagerProcessingException {
        BaseReleaser releaser = this.context.getModel().getRelease().getReleaser();
        String repoUrl = releaser.getResolvedRepoUrl(this.context.getModel(), ((AsdfPackager)this.packager).getRepository().getOwner(), ((AsdfPackager)this.packager).getRepository().getResolvedName());
        props.put("asdfPluginRepoUrl", repoUrl);
        props.put("asdfPluginToolCheck", Templates.resolveTemplate((String)((AsdfPackager)this.packager).getToolCheck(), props));
        String str = (String)props.get("distributionArtifactFile");
        str = str.replace(this.context.getModel().getProject().getEffectiveVersion(), "$ASDF_INSTALL_VERSION");
        props.put("asdfDistributionArtifactFile", str);
        str = (String)props.get("distributionArtifactFileName");
        str = str.replace(this.context.getModel().getProject().getEffectiveVersion(), "$version");
        props.put("asdfDistributionArtifactFileName", str);
        str = (String)props.get("distributionUrl");
        str = str.replace(this.context.getModel().getProject().getEffectiveVersion(), "$version");
        props.put("asdfDistributionUrl", str);
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        BaseReleaser gitService = this.context.getModel().getRelease().getReleaser();
        if (fileName.contains("github") && !(gitService instanceof GithubReleaser)) {
            return;
        }
        if (fileName.contains("-github")) {
            fileName = StringUtils.remove((String)fileName, (String)"-github");
        }
        fileName = TemplateUtils.trimTplExtension((String)fileName);
        Path outputFile = outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }
}

