/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.generator.impl.DefinitionKey;
import com.github.victools.jsonschema.generator.naming.DefaultSchemaDefinitionNamingStrategy;
import com.github.victools.jsonschema.generator.naming.SchemaDefinitionNamingStrategy;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.JReleaserVersion;
import org.jreleaser.model.internal.JReleaserModel;

public class JsonSchemaGenerator {
    public static void generate(PrintWriter out) {
        final LinkedHashMap<String, String> mappings = new LinkedHashMap<String, String>();
        mappings.put("Map<String, Object>", "Properties");
        mappings.put("Map<String, String>", "StringProperties");
        mappings.put("Map<String, WebhookAnnouncer>", "WebhookAnnouncerMap");
        mappings.put("Map<String, HttpAnnouncer>", "HttpAnnouncerMap");
        mappings.put("Map<String, ArchiveAssembler>", "ArchiveAssemblerMap");
        mappings.put("Map<String, JlinkAssembler>", "JlinkAssemblerMap");
        mappings.put("Map<String, JpackageAssembler>", "JpackageAssemblerMap");
        mappings.put("Map<String, NativeImageAssembler>", "NativeImageAssemblerMap");
        mappings.put("Map<String, Distribution>", "DistributionMap");
        mappings.put("Map<String, DockerSpec>", "DockerSpecMap");
        mappings.put("Map<String, ArtifactoryUploader>", "ArtifactoryUploaderMap");
        mappings.put("Map<String, GiteaUploader>", "GiteaUploaderMap");
        mappings.put("Map<String, GitlabUploader>", "GitlabUploaderMap");
        mappings.put("Map<String, FtpUploader>", "FtpUploaderMap");
        mappings.put("Map<String, HttpUploader>", "HttpUploaderMap");
        mappings.put("Map<String, SftpUploader>", "SftpUploaderMap");
        mappings.put("Map<String, ScpUploader>", "ScpUploaderMap");
        mappings.put("Map<String, S3Uploader>", "S3UploaderMap");
        mappings.put("Map<String, FtpDownloader>", "FtpDownloaderMap");
        mappings.put("Map<String, HttpDownloader>", "HttpDownloaderMap");
        mappings.put("Map<String, SftpDownloader>", "SftpDownloaderMap");
        mappings.put("Map<String, ScpDownloader>", "ScpDownloaderMap");
        mappings.put("Map<String, Extension>", "ExtensionMap");
        mappings.put("Map<String, ArtifactoryMavenDeployer>", "ArtifactoryMavenDeployerMap");
        mappings.put("Map<String, GiteaMavenDeployer>", "GiteaMavenDeployerMap");
        mappings.put("Map<String, GithubMavenDeployer>", "GithubMavenDeployerMap");
        mappings.put("Map<String, GitlabMavenDeployer>", "GitlabMavenDeployerMap");
        mappings.put("Map<String, Nexus2MavenDeployer>", "Nexus2MavenDeployerMap");
        try {
            SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2019_09, OptionPreset.PLAIN_JSON);
            configBuilder.getObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
            configBuilder.with(Option.FORBIDDEN_ADDITIONAL_PROPERTIES_BY_DEFAULT, new Option[0]);
            configBuilder.with(Option.DEFINITION_FOR_MAIN_SCHEMA, new Option[0]);
            configBuilder.with(Option.DEFINITIONS_FOR_ALL_OBJECTS, new Option[0]);
            JacksonModule jacksonModule = new JacksonModule();
            configBuilder.with((Module)jacksonModule);
            configBuilder.forTypesInGeneral().withDescriptionResolver(scope -> scope.getType().getErasedType() == JReleaserModel.class ? String.format("JReleaser %s", JReleaserVersion.getPlainVersion()) : null).withPatternPropertiesResolver(scope -> {
                ResolvedType type;
                if (scope.getType().isInstanceOf(Map.class) && (type = scope.getTypeParameterFor(Map.class, 1)).getErasedType() != String.class && type.getErasedType() != Object.class) {
                    return Collections.singletonMap("^[a-zA-Z-]+$", type);
                }
                return null;
            }).withAdditionalPropertiesResolver(scope -> {
                ResolvedType type;
                if (scope.getType().isInstanceOf(Map.class) && ((type = scope.getTypeParameterFor(Map.class, 1)).getErasedType() == String.class || type.getErasedType() == Object.class)) {
                    return scope.getTypeParameterFor(Map.class, 0);
                }
                return null;
            }).withDefinitionNamingStrategy((SchemaDefinitionNamingStrategy)new DefaultSchemaDefinitionNamingStrategy(){

                public String getDefinitionNameForKey(DefinitionKey key, SchemaGenerationContext context) {
                    String definitionNameForKey = super.getDefinitionNameForKey(key, context);
                    return mappings.getOrDefault(definitionNameForKey, definitionNameForKey);
                }
            });
            SchemaGeneratorConfig config = configBuilder.build();
            SchemaGenerator generator = new SchemaGenerator(config);
            ObjectNode jsonSchema = generator.generateSchema(JReleaserModel.class, new Type[0]);
            String fileName = String.format("jreleaser-%s-schema.json", JReleaserVersion.getPlainVersion());
            Path schemaPath = Paths.get(fileName, new String[0]);
            String json = configBuilder.getObjectMapper().writeValueAsString((Object)jsonSchema);
            Files.write(schemaPath, json.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            out.println("Schema written to " + schemaPath.toAbsolutePath());
        }
        catch (Exception e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }
}

