/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.SpecPackager;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.StringUtils;

public class SpecPackagerProcessor
extends AbstractRepositoryPackagerProcessor<SpecPackager> {
    public SpecPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPrepareDistribution(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        this.setupFiles(distribution, props);
        super.doPrepareDistribution(distribution, props);
    }

    private void setupFiles(Distribution distribution, Map<String, Object> props) throws PackagerProcessingException {
        Artifact artifact = (Artifact)props.get("distributionArtifact");
        Path artifactPath = artifact.getResolvedPath(this.context, distribution);
        String artifactFileName = StringUtils.getFilename((String)artifactPath.getFileName().toString(), (Collection)((SpecPackager)this.packager).getSupportedFileExtensions(distribution.getType()));
        if (distribution.getType() == Distribution.DistributionType.FLAT_BINARY) {
            props.put("projectVersion", this.context.getModel().getProject().version().toRpmVersion());
            props.put("specDirectories", Collections.emptyList());
            props.put("specBinaries", Collections.singletonList(distribution.getExecutable().resolveExecutable("linux")));
            props.put("specFiles", Collections.emptyList());
            return;
        }
        try {
            List entries = FileUtils.inspectArchive((Path)artifactPath);
            LinkedHashSet directories = new LinkedHashSet();
            ArrayList binaries = new ArrayList();
            ArrayList files = new ArrayList();
            entries.stream().filter(e -> !e.endsWith(distribution.getExecutable().resolveWindowsExtension())).filter(e -> !e.endsWith("/")).map(e -> e.substring(artifactFileName.length() + 1)).filter(e -> e.startsWith("bin/")).sorted().forEach(entry -> {
                String[] parts = entry.split("/");
                binaries.add(parts[1]);
            });
            entries.stream().filter(e -> !e.endsWith(distribution.getExecutable().resolveWindowsExtension())).filter(e -> !e.endsWith("/")).map(e -> e.substring(artifactFileName.length() + 1)).filter(e -> !e.startsWith("bin/")).sorted().forEach(entry -> {
                String[] parts = entry.split("/");
                if (parts.length > 1) {
                    directories.add(parts[0]);
                }
                files.add(entry);
            });
            props.put("projectVersion", this.context.getModel().getProject().version().toRpmVersion());
            props.put("specDirectories", directories);
            props.put("specBinaries", binaries);
            props.put("specFiles", files);
        }
        catch (IOException e2) {
            throw new PackagerProcessingException("ERROR", (Throwable)e2);
        }
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(distribution, props);
    }

    @Override
    protected void fillPackagerProperties(Map<String, Object> props, Distribution distribution) throws PackagerProcessingException {
        props.put("specPackageName", ((SpecPackager)this.packager).getPackageName());
        props.put("specRelease", ((SpecPackager)this.packager).getRelease());
        props.put("specRequires", ((SpecPackager)this.packager).getRequires());
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        Path outputFile = "app.spec".equals(fileName = TemplateUtils.trimTplExtension((String)fileName)) ? outputDirectory.resolve(((SpecPackager)this.packager).getPackageName().concat(".spec")) : outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }
}

